package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;

import java.util.List;
import java.util.Set;

/**
 * 比率控制器。
 *
 * @author allen
 * @date 2022-07-11
 * @since 1.0
 * @see RedisRatioControlImpl
 */
public interface RatioControl {

    /**
     * 开始比率控制。
     */
    void start();

    /**
     * 关闭比率控制。
     */
    void shutdown();

    /**
     * 触发一次流量平台的点击
     * @param clickId 已去重
     * @param app 媒体标识
     */
    void onClick(String clickId, String app);

    /**
     * 触发一次广告的点击
     *
     * @param clickLog 广告点击
     */
    void onAdClick(ClickLog clickLog);

    /**
     * 转化计数，一般情况下不需要主动调用。
     * 内部会根据控制的比率来按需调用。
     *
     * @see #pushConversion(FeedbackRequest, String)
     */
    void onConversion();

    /**
     * 暂存转化数据
     * @param request 回传请求
     * @param app 媒体标识
     */
    void pushConversion(FeedbackRequest request, String app);

    /**
     * 将删除所有历史数据。
     */
    void delete();

    /**
     * 获取实时数据
     *
     * @return 实时数据
     */
    Stat getStat();

    /**
     * 获取转化数降序 TopN 的媒体标识
     * @param start 开始
     * @param stop 结束
     * @return 媒体标识集合
     */
    Set<String> getTopN(int start, int stop);

    /**
     * 存储广告组数据
     *
     * @param dataList 数据结果集
     */
    void pushData(List<AdGroupData> dataList);

    /**
     * 获取广告组数据
     *
     * @return 数据结果集，可能为 null
     */
    List<AdGroupData> getDataList();

    /**
     * 获取控制器的集成总控。
     *
     * @return Bus
     */
    RatioControlBus getBus();

    /**
     * 刷新控制器的配置
     *
     * @param config 新的配置
     */
    void refreshConfig(RatioControlConfig config);

    /**
     * 获取控制器的配置。
     *
     * @return 配置
     */
    RatioControlConfig getConfig();

    /**
     * X +1
     */
    void onX();

    /**
     * 删除 X
     */
    void cleanX();
}
