package com.bxm.adscounter.rtb.common.control.ratio.event;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.data.AdGroupData;

import java.util.EventObject;
import java.util.List;

/**
 * 广告组数据获取事件
 *
 * @author allen
 * @date 2022-11-15
 * @since 1.0
 */
public class AdGroupFetchEvent extends EventObject {

    private final RatioControl control;
    private final List<AdGroupData> adGroupData;
    /**
     * 实时有效的
     */
    private final boolean realTimeData;

    public AdGroupFetchEvent(Object source, RatioControl control, List<AdGroupData> adGroupData, boolean realTimeData) {
        super(source);
        this.control = control;
        this.adGroupData = adGroupData;
        this.realTimeData = realTimeData;
    }

    public RatioControl getControl() {
        return control;
    }

    public List<AdGroupData> getAdGroupData() {
        return adGroupData;
    }

    public boolean isRealTimeData() {
        return realTimeData;
    }
}
