package com.bxm.adscounter.rtb.common.control.ratio.event;

import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;

import java.util.Objects;

/**
 * 回传给RTB平台失败事件
 *
 * @author allen
 * @date 2022-11-22
 * @since 1.0
 */
public class RatioFeedbackExceptionEvent extends AbstractRatioEvent {

    private final ClickLog clickLog;

    public RatioFeedbackExceptionEvent(Object source, RatioControl control, String adGroupId, String app, ClickLog clickLog) {
        super(source, control, adGroupId, app);
        this.clickLog = clickLog;
    }

    @Override
    public int getActionTypeForOpenLog() {
        return 5;
    }

    public boolean isFromClick() {
        return Objects.nonNull(clickLog);
    }

    public ClickLog getClickLog() {
        return clickLog;
    }
}
