package com.bxm.adscounter.rtb.common.control.ratio.event;

import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;

import java.util.Objects;

/**
 * 补量（回传了点击）事件
 *
 * @author allen
 * @date 2022-10-17
 * @since 1.0
 */
public class RatioPlusEvent extends AbstractRatioEvent {

    private final ClickLog clickLog;

    public RatioPlusEvent(Object source, RatioControl control, String adGroupId, String app, ClickLog clickLog) {
        super(source, control, adGroupId, app);
        this.clickLog = clickLog;
    }

    @Override
    public int getActionTypeForOpenLog() {
        return 4;
    }

    public boolean isFromClick() {
        return Objects.nonNull(clickLog);
    }

    public ClickLog getClickLog() {
        return clickLog;
    }
}
