package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioConversionEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import java.util.Objects;

/**
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
public class RatioConversionEventListener implements EventListener<RatioConversionEvent> {

    private final Counter counter;

    public RatioConversionEventListener(Counter counter) {
        this.counter = counter;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RatioConversionEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String dimension = config.getDimension();
        String app = event.getApp();

        counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.MINUS, 1, ListenerKey.ONE_DAY_SEC);

        counter.hincrementByAndGet(ListenerKey.hashData(Objects.toString(config.getHitConfigId())), ListenerKey.Field.RECEIVERS, 1, ListenerKey.ONE_DAY_SEC);

        counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.MINUS, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.MINUS, 1, ListenerKey.ONE_DAY_SEC);

        counter.hincrementByAndGet(ListenerKey.hashData(dimension), ListenerKey.Field.RECEIVERS, 1, ListenerKey.ONE_DAY_SEC);
        counter.hincrementByAndGet(ListenerKey.hashDataApp(dimension, app), ListenerKey.Field.RECEIVERS, 1, ListenerKey.ONE_DAY_SEC);
    }
}
