package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.AbstractRatioEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

/**
 * 智能回传处理日志发送给 OpenLog
 *
 * @author allen
 * @date 2022-10-19
 * @since 1.0
 */
public class RatioOpenLogEventListener implements EventListener<AbstractRatioEvent> {

    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RatioOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AbstractRatioEvent event) {
        int actionType = event.getActionTypeForOpenLog();
        if (actionType == -1) {
            return;
        }

        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String tagId = config.getTagId();
        Rtb rtb = control.getBus().getInstance().rtb();
        String adGroupId = event.getAdGroupId();
        String app = event.getApp();

        KeyValueMap map = new KeyValueMap();

        map.put(Common.RtbParam.P, Production.COMMON.getName());
        map.put(Common.RtbParam.MT, Common.Mt.RtbSmartConversion.original());
        map.put("action", actionType);
        map.put(Common.RtbParam.TAGID, tagId);
        map.put(Common.Param.RTB_ID, rtb.getType());
        map.put(Common.Param.AD_GROUP_ID, adGroupId);
        map.put("appid", app);
        map.put(Common.RtbParam.TIME, System.currentTimeMillis());
        map.put("duration", config.getDuration().getValue());
        map.put("plus_strategy", config.getPlusStrategy().getValue());

        String openLogRequestUri = map.createOpenLogRequestUri(properties.getOpenLogRequestDomain());
        openLogClient.asyncRequest(openLogRequestUri);
    }
}
