package com.bxm.adscounter.rtb.common.data;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * ad_group_id 维度数据。
 *
 * @author allen
 * @date 2022-11-15
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class AdGroupData {

    private String adGroupId;

    /**
     * 数据日期
     */
    private String date;

    /**
     * 小时粒度数据时才有值。
     */
    private Integer hour;

    /**
     * 花费，单位：元
     */
    private BigDecimal charge;

    /**
     * 浅层效果数
     */
    private Long shallowConvCount;

    /**
     * 浅层效果成本
     */
    private BigDecimal shallowConvCost;

    /**
     * 深层效果数
     */
    private Long deepConvCount;

    /**
     * 深层效果成本
     */
    private BigDecimal deepConvCost;

    /**
     * 转化数（计费时间）
     */
    private Long convNumByImpression;

    /**
     * cpa出价 单位：元
     */
    private BigDecimal cpa;

    /**
     * 数据获取时间
     */
    private long time;
}
