package com.bxm.adscounter.rtb.common.data;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 查询rtb库参数
 * </p>
 *
 * @author tangxiao
 * @since 2023-01-06
 */
@Data
@AllArgsConstructor
@Builder
public class QueryParam implements Serializable {

    /**
     * 日期，格式 yyyyMMDD
     */
    private String date;

    /**
     * 小时数
     */
    private String hour;

    /**
     * RTB智能回传控制维度的RTB平台id，例如快手广告组id
     */
    private String ad_group_id;

    private String appKey;

    private String business;

    /**
     * 查询行为，1.活动参与 2.券点击
     */
    private Integer action;

    /**
     * 广告id
     */
    private String adId;

    public String toSimpleString() {
        return "QueryParam{" +
                "date=" + date +
                ", hour=" + hour +
                ", ad_group_id=" + ad_group_id +
                ", appKey=" + appKey +
                ", business=" + business +
                '}';
    }
}