package com.bxm.adscounter.rtb.common.event;


import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;

import java.util.EventObject;

/**
 * rtb扣量日志事件
 * @author tangxiao
 * @date 2022/9/28
 * @since 1.0.0
 */
public class RtbDeductionEvent extends EventObject {
    private static final long serialVersionUID = -8847386450680497019L;

    public static final Integer DEDUCTION = 1;
    public static final Integer DEDUCTION_TICKET = 2;

    private Rtb rtb;
    private FeedbackRequest request;
    /**
     * 扣量类型：为空或1.转化扣量  2.券扣量
     */
    private Integer deductionType = DEDUCTION;

    public RtbDeductionEvent(Object source, Rtb rtb, FeedbackRequest request, Integer deductionType) {
        super(source);
        this.rtb = rtb;
        this.request = request;
        this.deductionType = deductionType;
    }

    public Rtb getRtb() {
        return rtb;
    }

    public void setRtb(Rtb rtb) {
        this.rtb = rtb;
    }

    public FeedbackRequest getRequest() {
        return request;
    }

    public void setRequest(FeedbackRequest request) {
        this.request = request;
    }

    public Integer getDeductionType() {
        return deductionType;
    }
}
