package com.bxm.adscounter.rtb.common.feedback;

import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 回传请求
 *
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FeedbackRequest {

    /**
     * 浅层转化级别
     */
    public static final int SHALLOW_CONVERSION_LEVEL = 1;
    /**
     * 深层转化级别
     */
    public static final int DEEP_CONVERSION_LEVEL = 2;

    /**
     * 当前广告位的 RTB 相关配置。
     */
    private PositionRtb config;
    /**
     * 本次转化级别，1 表示浅层，大于 1 表示深层。为了可扩展才设计成 int 类型。
     */
    private int conversionLevel = SHALLOW_CONVERSION_LEVEL;
    /**
     * 变现猫收到广告主的转化类型。
     */
    private String conversionType;
    /**
     * 当前行为日志。
     */
    private KeyValueMap keyValueMap;
    /**
     * 回传给流量平台的转化类型。
     */
    private String eventType;
    /**
     * 优先使用这个值，如果返回空，则从 {@link #getReferrer()} 中获取。
     */
    private String clickId;
    /**
     * Referrer，一般是当时互动活动的URL。
     */
    private String referrer;
    /**
     * RTB 平台唯一标识，不同平台的字段名不一致。如：快手是广告组。
     */
    private String adGroupId;
    /**
     * 本次回传的初始行为类型。有可能 {@code null}
     */
    private ActionType actionType;
    /**
     * 本次回传的智能处理分类，默认：{@link SmartConvType#NONE}
     */
    private SmartConvType smartConvType = SmartConvType.NONE;

    // ---- 请求后由内部实现回填，主要为了采集和监控 ---- //

    /**
     * 请求地址
     */
    private String requestUrl;
    /**
     * 请求体，一般用于POST请求
     */
    private String requestBody;
    /**
     * RTB平台的媒体标识符，主要在智能回传里使用的。
     */
    private String appid;

    // ---- 重试相关 ---- //

    /**
     * 重试次数，不重试为 0，首次回传不计算次数。
     */
    private int retryTimes;

    /**
     * 是否为ocpx请求, 为部分共用的实现做区分
     */
    private boolean ocpxRequest = false;

    /**
     * 当前回传是深层转化
     * @return 返回 true 表示深层
     */
    public boolean isDeepConversion() {
        return conversionLevel > SHALLOW_CONVERSION_LEVEL;
    }

    public int incrementRetryTimes() {
        this.retryTimes++;
        return this.retryTimes;
    }

    public boolean isOcpxRequest() {
        return ocpxRequest;
    }
}
