package com.bxm.adscounter.rtb.common.feedback;

/**
 * @author allen
 * @date 2022-12-19
 * @since 1.0
 */
public enum SmartConvType {
    /**
     * 不是智能转化
     */
    NONE("0"),
    /**
     * 来自转化队列，智能转化被暂存后的回传
     */
    CONV_QUEUE("1"),
    /**
     * 来自点击队列，智能转化队列不足时取点击回传
     */
    CLICK_QUEUE("2"),

    /**
     * 来自累加回传模式中累加或者扣量暂存的回传
     */
    SMART_HOSTING_QUEUE("3")
    ;

    private final String value;

    SmartConvType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
    }
