package com.bxm.adscounter.rtb.common.impl.alipaydh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayDataDataserviceAdConversionUploadRequest;
import com.alipay.api.response.AlipayDataDataserviceAdConversionUploadResponse;
import com.bxm.adscounter.integration.utils.HttpClientUtils;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.impl.qimao.QiMaoConfig;
import com.bxm.adscounter.rtb.common.impl.tencent.TencentConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Qualifier;
import java.util.Optional;

/**
 * 支付宝灯火 采用ip归因的方式
 * <p>
 * click_id在点击监测中，点击建聪链接如下：
 * https://openlog.bianxianmao.com/common/s.gif?mt=30&rtb_id=38&tagid=positionId&
 * oaid=__OAID_MD5__&idfa=__IDFA_MD5__&request=__REQUEST_ID__&ts=__TS__&os=__OS__&
 * c_id=__AD_ID__&ad_group_id=__GROUP_ID__&ad_plan_id=__PLAN_ID__&account_id=__PRINCIPAL_ID__
 * &click_id=__CALLBACK_EXT_INFO__&ip=__IP__&ua=__UA__
 *
 * @author daill
 * @date 2023-11-02
 * @since 1.0
 */
@Slf4j
public class AlipayDHRtbIntegration extends AbstractClickTrackerRtbIntegration {


    public static final String appId = "2021004123620167";
    public static final String privateKey = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDBnzhspj8HtRjE0NoHtAE0j5iF/htpqNWUtYACHnSBodeiaeZpxTavgb2HiRkni4Tw8tt4kCzguAcuv6IQ8AM4PkWioFPioHd54EsP6a8xASEFfJCHApLhtKQ8fpgfzXiSZJSbuUVdAaS/3Juwugz6A3tX+gABvffpCM7eF1vzP+EmIiTQVyvmgUwZVIwg3Y1QYIiVQbHrCfgih/kwOkZjspPLG7RHJF+SVZ6zmjlKb2StM6Cs0OKQ9iRjx38JoxpiXvroYPJHo1uZfQRtFuEZihfEkKl5s5KAlQgtl+P6H6j2G/qoC/zhs4qydHxqm3QDjzGNMBwQMWIhdlYu7j/3AgMBAAECggEAcXahtSHTC+w3IJcXPa5hinCfu93GKKvUxXl7E0LPmWvDFp0idlcojb7k1zkjMYZUGHLo5ATxF5sgMmgATBaqfFoZqoxzu/m3KgejVSbnEDuOI030z/lVI8kc+YpiETjycC9a2sq+eBtPdVONNQpCMny52jtZp6uwTLJpr8JWkvuV0pntfkAIKJ3AsOEOPv9K8Ne1yDbL9OEPB9GgCTaTwWlDfyHqWGQ9RAcDSDclpcxgPp/SRNkrn2GtRA9CJwFuknHtJ5CYT2EGw5uLw6HAxvIEoosjDpshweWy1JH2UE8/OsuhDg5PgCfEvcK+ZfsWH2QZp+pQ7yCmF7HcouTl8QKBgQDrxXK3v9PhWMnfYqyMouUSF4sOcNBaSQqPfQqtaGS1Z8MUI9VcgcLDFejw9VYjqsQtLGEVAk7TbS/PwnsAsR4eyANnMDrAtSZGHEdYGjY4MgIsTxsvuSoUF8vbNQsfO3NHHhrtSofQZLu4FwzBOCgEjvYvSwccyhkrn4WbPkb13wKBgQDSO/3gDGBmU11cawcciNvkYy1ofehAmskCgdmGZOBaEI80g46CoUuhN4uDOixyziY2vkmOtTXb+CpCinVR9NrvN/5ujC009xz+2QrUXuR/HlhcsZRJnr1/eA+RfUYjdRRHRgtHTnga378qAWbqvUhvAXOBuMPPtCZSrMnVRYaI6QKBgQCtdV6pAWCI8iHTT21TKqUNYnTT8vvW8NXsKzqnyZ4OOIC1WIeov27iyEPQwy7UntYlxfjG1CPaOQJr/9Eu+SAH1W9rg3g2PxAhlLyIfQBW57PhlXGS8s+aaMd6RtQf7kUplWSKH8M79mCFV6/yl7YZZHSK5tAcxjMufPZ2+KKMUQKBgBfPD3tWK3yrKEGVJWMH5M9CpBvXVnwqi2UrS3U662WHxpAN7g/BMI17euNLrUj7K7y7ZB0zTHwy6KZMg+jaMAkzcC8Y1O3Qpon+DonqjToQN7WXrtF/lrpe4HR7mXvegINp3VEgA94XRND/A6bF9PQNWAVy5UoaftSSGPF8RDYxAoGBAN6Re/IdL/2SBA9tUk5vxdR3iOi11vAU3CmgpG7CJAMR4HOc78mQuzc15Aj92NZTRiK6sCxs0T/lkKHhT8MwVM1AhAplQZwPlmHpT7vGud9YtJTYObClWX+J5da0nWEcqYlMnglwBYU/s752uKWsyN/blFYulTiYsL6xFzwl/o1S";
    private final Fetcher fetcher;
    public static final String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAiCl0dngSaPTJmnA4mES+wKEgNz/ZiCojILXRN2AkXC992UkafxvWDDpScNjsxmT8kaVu89NJPG6Fp6NcRmKrcL0Cpm4kCIJyUTjA4WGaNSoWpfvPxu8MmCobxa+mFSewqc2fXPcdEytBPFUz5wYeaNn8MRsB0k+N8RgXS7B3iqz2g5JkXvGFFguG0Wi/540E69tvXYCSu8qgei2moVrfqnQvRIiKI4315m2NsZMrJAww5JyBIm17wq3qOOsI23N4H6Px+jAZFgURGw2bP7HPpnCQAlR7k5sAArF5ppsmeJZK8GklYnHerwNykXf/kgrajIk5a9nguY0eFQunCTYiQwIDAQAB";
    private final AlipayDHConfig config;

    public AlipayDHRtbIntegration(AlipayDHConfig config, @Qualifier("rtbJedisFetcher") Fetcher fetcher) {
        super(config);
        this.fetcher = fetcher;
        this.config = config;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String ip = clickEventLog.getFirst(Common.Param.IP);
        if (StringUtils.isNotBlank(ip)) {
            return fetcher.fetch(RedisKeyGenerator.strAlipaydhIpClickId(ip), String.class);
        }
        return Strings.EMPTY;
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String clickId = getClickIdOnInadsAdClickLog(request.getKeyValueMap());
        if (StringUtils.isNotBlank(clickId)) {
            KeyValueMap clickTracker = getClickTracker(clickId);
            return Optional.ofNullable(clickTracker)
                    .map(k -> k.getFirst(Common.Param.AD_GROUP_ID))
                    .orElse(StringUtils.EMPTY);
        }
        return Strings.EMPTY;
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    public FeedbackResponse doFeedback(FeedbackRequest request, int status) throws RtbIntegrationException {
        try {
            String eventType = request.getEventType();
            KeyValueMap keyValueMap = request.getKeyValueMap();
            String ip = keyValueMap.getFirst(Common.Param.IP);
            String bxmId = keyValueMap.getFirst(Inads.Param.BXMID);
            String clickId = getClickIdOnInadsAdClickLog(keyValueMap);

            if (StringUtils.isBlank(clickId)) {
                throw new RtbIntegrationException(FailType.IllegalParameter,
                        String.format("ip: %s Cannot found clickId. keyValueMap: %s", ip, JSONObject.toJSONString(keyValueMap)));
            }
            String customerId = request.getConfig().getCustomerId();
            String token = request.getConfig().getToken();
            AlipayClient alipayClient = new DefaultAlipayClient(config.getUrl(),
                    appId, privateKey,
                    "json", "GBK", publicKey, "RSA2");
            AlipayDataDataserviceAdConversionUploadRequest alipayRequest = new AlipayDataDataserviceAdConversionUploadRequest();
            alipayRequest.setBizContent("{" +
                    "  \"biz_token\":\""+token+"\"," +
                    "  \"conversion_data_list\":[" +
                    "    {" +
                    "      \"source\":\"COMMON_TARGET\"," +
                    "      \"principal_tag\":\""+customerId+"\"," +
                    "      \"biz_no\":\"" + bxmId + "\"," +
                    "      \"conversion_type\":\""+eventType+"\"," +
                    "      \"conversion_time\":" + System.currentTimeMillis() / 1000 + "," +
                    "      \"uuid_type\":\"PID\"," +
                    "      \"uuid\":\"2088UID\"," +
                    "      \"property_list\":[" +
                    "        {" +
                    "          \"key\":\"tinyapp_id\"," +
                    "          \"value\":\""+appId+"\"" +
                    "        }" +
                    "      ]," +
                    "      \"callback_ext_info\":\""+UrlHelper.urlDecode(clickId)+"\"" +
                    "    }" +
                    "  ]" +
                    "}");
            AlipayDataDataserviceAdConversionUploadResponse alipayResponse = alipayClient.execute(alipayRequest);
            if (alipayResponse.isSuccess()) {
               return this.convert(request,null);
            } else {
                FeedbackResponse feedbackResponse = new FeedbackResponse();
                feedbackResponse.setSuccess(false);
                feedbackResponse.setBody(JSON.toJSONString(alipayResponse));
                return feedbackResponse;
            }
        }catch (Exception e){
            throw new RtbIntegrationException(FailType.OtherException, e);
        }
    }

    @Override
    public Rtb rtb() {
        return Rtb.ALIPAY_DH;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        return null;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
