package com.bxm.adscounter.rtb.common.impl.bigo;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author tangxiao
 * @date 2022-07-05
 * @since 1.0
 */
@Slf4j
public class BigoRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private BigoConfig bigoConfig;


    public BigoRtbIntegration(BigoConfig config) {
        super(config);
        bigoConfig = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.Bigo;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();

        String sid;
        String appId;
        if (request.isOcpxRequest()) {
            sid = queryParams.getFirst("click_id");
            appId = queryParams.getFirst("sub_id");
        } else {
            sid = queryParams.getFirst("sid");
            appId = queryParams.getFirst("appId");
        }
        String idfa = queryParams.getFirst("idfa");
        String gaid = queryParams.getFirst("gaid");

        if (StringUtils.isBlank(sid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sid'.");
        }
        if (StringUtils.isBlank(appId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'appId'.");
        }
        if (StringUtils.isBlank(idfa) && StringUtils.isBlank(gaid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'idfa' or 'gaid'.");
        }

        BigoRequest vivoRequest = BigoRequest.builder()
                .appKey(bigoConfig.getAppkey())
                .sid(sid)
                .appId(appId)
                .idfa(idfa)
                .gaid(gaid)
                .mappedIae(eventType)
                .build();

        String entity = JsonHelper.convert(vivoRequest);
        if (log.isInfoEnabled()) {
            log.info("【bigo】request body : {}", entity);
        }

        String url = getFeedbackUrl();
        HttpPost post = new HttpPost(url);
        post.setEntity(new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
        request.setRequestBody(entity);
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }


}
