package com.bxm.adscounter.rtb.common.impl.domob;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2022-08-02
 * @since 1.0
 */
@Slf4j
public class DomobRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private DomobConfig domobConfig;


    public DomobRtbIntegration(DomobConfig config) {
        super(config);
        domobConfig = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.Domob;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "dm_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String dmId = queryParams.getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(dmId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("event_type", eventType);
        params.put("act_ts", String.valueOf(System.currentTimeMillis()));
        params.put("dm_id", dmId);
        params.put("appkey", domobConfig.getAppKey());

        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }


}
