package com.bxm.adscounter.rtb.common.impl.domobOcpx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author tangxiao
 * @date 2022-06-25
 * @since 1.0
 */
@Slf4j
public class DomobOcpxRtbIntegration extends AbstractClickTrackerRtbIntegration {


    public DomobOcpxRtbIntegration(DomobOcpxConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.DomobOcpx;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {

        String eventType = request.getEventType();
        String callback = request.getClickId();

        if (StringUtils.isBlank(eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }
        if (StringUtils.isBlank(callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback'.");
        }

        String url = UriComponentsBuilder.fromUriString(UrlHelper.urlDecode(callback))
                .replaceQueryParam("transformType", eventType)
                .build()
                .toUriString();

        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }


}
