package com.bxm.adscounter.rtb.common.impl.hiv;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;
import java.util.Objects;

/**
 * @author pf.w
 * @date 2023/3/29 10:51
 */
public class HivRtbIntegration extends AbstractClickTrackerRtbIntegration {
    public HivRtbIntegration(HivConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.HIV;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String clickId = request.getClickId();

        if (StringUtils.isBlank(clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("transaction_id", clickId);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse =new FeedbackResponse();
        feedbackResponse.setSuccess(StringUtils.isNotBlank(body) && Objects.equals("success",body));
        return feedbackResponse;
    }
}
