package com.bxm.adscounter.rtb.common.impl.jiguangadx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
public class JiguangAdxRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public JiguangAdxRtbIntegration(RtbConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.JiGuangAdx;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "req_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String reqId = queryParams.getFirst(clickIdParameterNameOnReferrer);
        String chl = queryParams.getFirst("chl");
        if (StringUtils.isBlank(reqId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer +"' by referrer.");
        }
        if (StringUtils.isBlank(chl)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'chl' by referrer.");
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("req_id", reqId);
        params.put("event", eventType);
        params.put("chl", chl);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}
