package com.bxm.adscounter.rtb.common.impl.kuaishou;

import com.bxm.adscounter.rtb.common.impl.AbstractRtbConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @date 2022-05-13
 * @since 1.0
 */
@ConfigurationProperties(prefix = "rtb.kuaishou")
public class KuaishouConfig extends AbstractRtbConfig {

    /**
     * 表单
     */
    public static final String EVENT_TYPE_FORM = "9";
    /**
     * 付费
     */
    public static final String EVENT_TYPE_USER_PAY = "3";
    /**
     * 有效线索
     */
    public static final String EVENT_TYPE_VALID_CLUES = "44";

    private String url = "http://ad.partner.gifshow.com/track/activate";
    private String urlUnitReport = "https://ad.e.kuaishou.com/rest/openapi/v1/report/unit_report";
    private String urlUnitList = "https://ad.e.kuaishou.com/rest/openapi/gw/dsp/unit/list";

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return url;
    }

    public String getUrlUnitReport() {
        return urlUnitReport;
    }

    public void setUrlUnitReport(String urlUnitReport) {
        this.urlUnitReport = urlUnitReport;
    }

    public String getUrlUnitList() {
        return urlUnitList;
    }

    public void setUrlUnitList(String urlUnitList) {
        this.urlUnitList = urlUnitList;
    }
}
