//package com.bxm.adscounter.rtb.common.impl.kuaishou.dailydata;
//
//import com.alibaba.fastjson.JSONException;
//import com.alibaba.fastjson.JSONObject;
//import com.bxm.adscounter.rtb.common.DataFetchFailException;
//import com.bxm.adscounter.rtb.common.data.AdGroupData;
//import com.bxm.adscounter.rtb.common.data.Parameter;
//import com.bxm.adscounter.rtb.common.impl.AbstractHttpRtbIntegration;
//import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouAk;
//import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
//import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouDataFetcher;
//import com.bxm.warcar.utils.JsonHelper;
//import com.bxm.warcar.utils.KeyBuilder;
//import com.google.common.collect.Lists;
//import lombok.Data;
//import org.apache.commons.collections.CollectionUtils;
//import org.apache.commons.lang.StringUtils;
//import org.apache.http.HttpHeaders;
//import org.apache.http.HttpResponse;
//import org.apache.http.client.HttpClient;
//import org.apache.http.client.methods.HttpPost;
//import org.apache.http.entity.StringEntity;
//import org.apache.http.util.EntityUtils;
//import org.springframework.http.MediaType;
//import redis.clients.jedis.Jedis;
//import redis.clients.jedis.JedisPool;
//
//import java.io.IOException;
//import java.math.BigDecimal;
//import java.time.LocalDate;
//import java.time.LocalDateTime;
//import java.time.LocalTime;
//import java.time.format.DateTimeFormatter;
//import java.util.List;
//import java.util.Objects;
//import java.util.Optional;
//
///**
// * @author tangxiao
// * @date 2023/10/9
// * @since 1.0
// */
//public class KuaishouDailyDataFetcher {
//
//    private final KuaishouConfig config;
//    private final JedisPool jedisPool;
//    private final HttpClient httpClient;
//
//    public KuaishouDailyDataFetcher(KuaishouConfig config, JedisPool jedisPool) {
//        this.config = config;
//        this.httpClient = AbstractHttpRtbIntegration.createHttpClient(config);
//        this.jedisPool = jedisPool;
//    }
//
//    private static String getToday() {
//        return getToday(0);
//    }
//
//    private static String getToday(long days) {
//        return LocalDate.now().plusDays(days).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
//    }
//
//    public List<AdGroupData> fetchDaily(Parameter parameter) throws DataFetchFailException {
//        final String today = (LocalTime.now().getHour() == 0) ? getToday(-1) : getToday();
//        return fetch0(parameter, today);
//    }
//
//    private List<AdGroupData> fetch0(Parameter parameter, String date) throws DataFetchFailException {
//        String tagId = parameter.getTagId();
//        String advertiserId = parameter.getAdvertiserId();
//        String adGroupId = parameter.getAdGroupId();
//        String shallowEventType = parameter.getShallowEventType();
//        String deepEventType = parameter.getDeepEventType();
//
//        String json = null;
//        try {
//            if (StringUtils.isBlank(advertiserId)) {
//                throw new DataFetchFailException("'advertiserId' 不能为空，在广告位：" + tagId);
//            }
//
//            // 先使用GLOBAL获取，获取不到再使用广告位。
//            KuaishouAk ak = getAk("GLOBAL", advertiserId);
//            if (Objects.isNull(ak)) {
//                ak = getAk(tagId, advertiserId);
//            }
//
//            if (Objects.isNull(ak)) {
//                throw new DataFetchFailException(String.format("没有找到 AK 密钥，在广告位：%s 和 advertiserId：%s", tagId, advertiserId));
//            }
//
//            String accessToken = ak.getAccessToken();
//
//            JSONObject params = new JSONObject();
//            params.put("advertiser_id", advertiserId);
//            params.put("start_date", date);
//            params.put("end_date", date);
//            if (StringUtils.isNotBlank(adGroupId)) {
//                params.put("unit_ids", new String[] {adGroupId});
//            }
//            HttpPost post = new HttpPost(config.getUrlUnitList());
//            post.setEntity(new StringEntity(params.toJSONString()));
//            post.addHeader("Access-Token", accessToken);
//            post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
//
//            HttpResponse hr = httpClient.execute(post);
//            json = EntityUtils.toString(hr.getEntity());
//            KuaishouDataFetcher.KsUnitReportRes res = JSONObject.parseObject(json, KuaishouDataFetcher.KsUnitReportRes.class);
//            if (!res.isSuccess()) {
//                throw new DataFetchFailException(String.format("接口请求不成功！广告位：%s，advertiserId：%s。返回结果：%s", tagId, advertiserId, json));
//            }
//            return convert(res, shallowEventType, deepEventType);
//        } catch (IOException e) {
//            throw new DataFetchFailException(String.format("接口网络异常（%s）！广告位：%s，advertiserId：%s。", e.getClass().getName(), tagId, advertiserId));
//        } catch (JSONException e) {
//            throw new DataFetchFailException(String.format("接口返回数据异常！广告位：%s，advertiserId：%s。返回结果：%s", tagId, advertiserId, json));
//        }
//    }
//
//    private KuaishouAk getAk(String tagId, String advertiserId) {
//        try (Jedis jedis = jedisPool.getResource()) {
//            String v = jedis.hget(KeyBuilder.build("rtb", "conv", "AK", tagId), advertiserId);
//            return Optional.ofNullable(v)
//                    .filter(StringUtils::isNotBlank)
//                    .map(s -> JsonHelper.convert(s, KuaishouAk.class))
//                    .orElse(null);
//        }
//    }
//
//    private List<AdGroupData> convert(KsUnitListRes res, String shallowEventType, String deepEventType) {
//        if (!res.isSuccess()) {
//            return null;
//        }
//        KuaishouDataFetcher.KsData<KsUnitList> ksData = res.getData();
//        if (Objects.isNull(ksData)) {
//            return null;
//        }
//        List<KsUnitList> details = ksData.getDetails();
//        if (CollectionUtils.isEmpty(details)) {
//            return null;
//        }
//
//        List<AdGroupData> ret = Lists.newArrayList();
//        details.forEach(e -> {
//            AdGroupData adGroupData = new AdGroupData()
//                    .setAdGroupId(e.getUnit_id())
//                    .setDate(e.getStat_date())
//                    .setHour(e.getStat_hour())
//                    .setCharge(e.getCharge())
//                    .setTime(System.currentTimeMillis());
//            ret.add(adGroupData);
//        });
//
//        return ret;
//    }
//
//    public static class KsUnitListRes extends KuaishouDataFetcher.Ks<KsUnitList> {}
//
//    @Data
//    public static class Ks<T> {
//
//        private int code = -1;
//        private String message;
//        private KuaishouDataFetcher.KsData<T> data;
//
//        public boolean isSuccess() {
//            return code == 0;
//        }
//    }
//
//    @lombok.Data
//    public static class KsData<T> {
//        private int total_count;
//        private List<T> details;
//    }
//
//    @lombok.Data
//    public static class KsUnitList {
//        private String unit_id;
//        private String cpa_bid;
//    }
//
//}
