package com.bxm.adscounter.rtb.common.impl.meituan;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2022-06-21
 * @since 1.0
 */
@Slf4j
public class MeituanRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private MeituanConfig config;

    public MeituanRtbIntegration(MeituanConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.MeiTuan;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "exposure_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String aid = queryParams.getFirst("aid");
        String cid = queryParams.getFirst("cid");
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String exposure_id = queryParams.getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(aid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'aid' by referrer.");
        }
        if (StringUtils.isBlank(cid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'cid' by referrer.");
        }
        if (StringUtils.isBlank(exposure_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }

        Map<String, Object> params = Maps.newLinkedHashMap();
        params.put("aid", aid);
        params.put("cid", cid);
        params.put("event_type", eventType);
        // 付费
        params.put("event_value", 0);
        params.put("timestamp", System.currentTimeMillis());
        params.put("exposure_id", exposure_id);
        params.put("sign", getSign(params));

        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    private String getSign(Map<String, Object> params) {
        StringBuilder paramStringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (paramStringBuilder.length() > 0) {
                paramStringBuilder.append("&");
            }
            paramStringBuilder.append(entry.getKey())
                    .append("=")
                    .append(entry.getValue());
        }
        paramStringBuilder.append(config.getKey());

        return DigestUtils.md5Hex(paramStringBuilder.toString());

    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
