package com.bxm.adscounter.rtb.common.impl.mkit;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;

/**
 * @author pf.w
 * @date 2023/3/29 10:51
 */
public class MkitRtbIntegration extends AbstractClickTrackerRtbIntegration {
    public MkitRtbIntegration(MkitConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.MKIT;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String clickId = request.getClickId();

        if (StringUtils.isBlank(clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("click_id", clickId);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        MkitResponse mkitResponse = JsonHelper.convert(body,MkitResponse.class);
        FeedbackResponse feedbackResponse =new FeedbackResponse();
        feedbackResponse.setSuccess(mkitResponse != null &&mkitResponse.isSuccess());
        return feedbackResponse;
    }

    @Data
    public static class MkitResponse {
        private Integer code;
        private String msg;
        private Integer status;
        private boolean succ;

        public boolean isSuccess() {
            return status == 200;
        }
    }
}
