package com.bxm.adscounter.rtb.common.impl.qtt;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;


/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
public class QttRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public QttRtbIntegration(QttConfig config) {
        super(config);
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "callback_url";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();

        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String callBack = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(callBack)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        callBack = UrlHelper.urlDecode(callBack);
        return new HttpGet(callBack.trim() + "&op2=" + eventType);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Qtt;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return JsonHelper.convert(body, Response.class);
    }


    private static class Response extends FeedbackResponse {

        private String code;
        private String message;
        private String data;
        private String request_id;
        private String currentTime;
        private String status;

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase("0", code) || StringUtils.equalsIgnoreCase("200", status);
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getRequest_id() {
            return request_id;
        }

        public void setRequest_id(String request_id) {
            this.request_id = request_id;
        }

        public String getCurrentTime() {
            return currentTime;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setCurrentTime(String currentTime) {
            this.currentTime = currentTime;
        }
    }
}
