package com.bxm.adscounter.rtb.common.impl.smallstep;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2023-03-13
 * @since 1.0
 */
@Slf4j
public class SmallStepRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public SmallStepRtbIntegration(SmallStepConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.SmallStep;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();

        MultiValueMap<String, String> queryParams = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams();
        String sub1 = queryParams.getFirst("sub1");
        String sub2 = queryParams.getFirst("sub2");
        String sub3 = queryParams.getFirst("sub3");
        String sub4 = queryParams.getFirst("sub4");

        if(StringUtils.isBlank(sub1)){
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub1' by referrer.");
        }
        if(StringUtils.isBlank(sub2)){
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub2' by referrer.");
        }
        if(StringUtils.isBlank(sub3)){
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub3' by referrer.");
        }
        if(StringUtils.isBlank(sub4)){
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'sub4' by referrer.");
        }


        Map<String, Object> params = Maps.newHashMap();
        params.put("s_param1", sub1);
        params.put("s_param2", sub2);
        params.put("s_param3", sub3);
        params.put("s_param4", sub4);
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse =new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
