package com.bxm.adscounter.rtb.common.impl.tencent;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 广点通
 *
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
public class TencentRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public static final String CLICK_ID = "qz_gdt";
    private final TencentConfig config;

    public TencentRtbIntegration(TencentConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return clickTrackerKeyValueMap.getFirst(Common.Param.CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName(clickEventLog.getRef(), CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString(referrer).build();
        MultiValueMap<String, String> queryParams = build.getQueryParams();
        String clickId = queryParams.getFirst(CLICK_ID);
        KeyValueMap clickTracker = getClickTracker(clickId);

        return Optional.ofNullable(clickTracker)
                .map(k -> k.getFirst(Common.Param.AD_GROUP_ID))
                .orElse(StringUtils.EMPTY);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();

        String tencentLinkCfg = request.getConfig().getCustomerId();
        String tencentLink = StringUtils.isNotBlank(tencentLinkCfg) ? tencentLinkCfg : config.getTencentLink();

        String clickid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(CLICK_ID);
        if (StringUtils.isBlank(clickid)) {
           clickid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst("gdt_vid");
        }
        if(StringUtils.isEmpty(clickid)){
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickid' by referrer.");
        }
        Map<String, Object> params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("action_type", eventType);
        params.put("action_time", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("link", tencentLink);

        //如果广告位rtb配置 浅层或深层目标为PURCHASE（付费）&& 付费金额不为空，回传给媒体
        PositionRtb config = request.getConfig();
        String payAmount = request.getKeyValueMap().getFirst(Inads.Param.PAY_AMOUNT);
        if ((StringUtils.equals(config.getTargetOneRtb(),"PURCHASE") || StringUtils.equals(config.getTargetTwoRtb(),"PURCHASE")) && StringUtils.isNotBlank(payAmount)) {
            Float aFloat = Float.valueOf(payAmount);
            Float value = aFloat * 100;
            ActionParam build = ActionParam.builder().value(value.intValue()).build();
            params.put("action_param", JSONObject.toJSONString(build));
        }

        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.GuangDianTong;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse =new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    @Data
    @Builder
    private static class ActionParam {
        private Integer value;
    }
}
