package com.bxm.adscounter.rtb.common.impl.vivo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author tangx
 * @date 2022/6/21 16:03
 */
@Data
@Builder
@AllArgsConstructor
public class VivoRequest {

    private String srcType;
    /**
     * 页面url,
     * 当数据源类型为Web时,该字段必传
     */
    private String pageUrl;
    /**
     * 应用包名,
     * 当数据源类型为APP时,该字段必传
     */
    private String pkgName;
    private String srcId;
    private List<Data> dataList;

    @lombok.Data
    public static class Data {
        /**
         * 用户标识类型,
         * 枚举值IMEI/IMEI_MD5/OAID/OAID_MD5/OTHER/OPENID,
         * 当数据源类型为APP时,该字段必传。
         */
        private String userIdType;
        /**
         * 标识的值，如IMEI号等,
         * 当数据源类型为APP时,该字段必传。
         * IMEI：15-17位，明文
         * IMEI_MD5 ：32位，加密
         * OAID：64位，明文
         * OAID_MD5：32位   加密
         * OTHER：不限
         * OPENID：不限
         */
        private String userId;
        private String cvType;
        private Long cvTime;
        private String requestId;
        private String creativeId;

        /**
         * 扩展参数, key 为参数名, value 为参数值。（仅微信小游戏类型付费事件必传）
         * key 包括以下类型
         * 1) payAmount: 付费金额, 单位分,微信小游戏付费事件时,该key必填
         * 2) unionId: 选填, cvType=微信小游戏注册/微信小游戏付费时建议回传
         */
        private Map<String,String> extParam;
    }
}
