package com.bxm.adscounter.rtb.common.impl.wifi;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * @author daill
 * @date 2022-06-27
 * @since 1.0
 */
@Slf4j
public class WifiRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private final WifiConfig config;

    public WifiRtbIntegration(WifiConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "sid";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String clickIdParameterNameOnReferrer = getClickIdParameterNameOnReferrer();
        String sid = UriComponentsBuilder.fromUriString(referrer).build().getQueryParams().getFirst(clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank(sid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        PositionRtb config = request.getConfig();
        Map<String, Object> params = Maps.newHashMap();
        params.put("clientid", config.getCustomerId());
        params.put("sid", sid);
        params.put("event_type", eventType);
        //params.put("ts", String.valueOf(System.currentTimeMillis() / 1000));
        params.put("sign", getSign(params, config.getToken()));
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    private static String getSign(Map<String, Object> params, String token) {
        // 将参数以参数名的字典升序排序
        Map<String, Object> sortParams = new TreeMap<>(params);
        Set<Map.Entry<String, Object>> entrys = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry<String, Object> entry : entrys) {
            valueSb.append(entry.getKey())
                    .append("=")
                    .append(entry.getValue())
                    .append("&");
        }
        String value = valueSb.toString().substring(0, valueSb.toString().length() - 1) + token;
        return DigestUtils.md5Hex(value).toUpperCase();

    }

    @Override
    public Rtb rtb() {
        return Rtb.WIFI;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }
}
