package com.bxm.adscounter.rtb.common.impl.wifiocpx;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.http.OkHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.*;

/**
 * @author zhangdong
 * @date 2023/3/14
 */
@Slf4j
public class WifiOcpxRtbIntegration extends AbstractClickTrackerRtbIntegration {

    private final WifiOcpxConfig config;

    public WifiOcpxRtbIntegration(WifiOcpxConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        Map<String, Object> params = new HashMap<>(15);
        params.put("cid", keyValueMap.getFirst("cid"));
        params.put("sid", keyValueMap.getFirst("sid"));
        params.put("stime", keyValueMap.getFirst("sid"));
        params.put("os", keyValueMap.getFirst("os"));
        params.put("idfa", keyValueMap.getFirst("idfa"));
        params.put("mac", keyValueMap.getFirst("mac"));
        params.put("imei", keyValueMap.getFirst("imei"));
        params.put("clientid", config.getClientId());
        params.put("event_type", request.getEventType());
        params.put("ts", System.currentTimeMillis());
        params.put("sign", getSign(params, config.getSecretKey()));
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    private String getSign(Map<String, Object> params, String token) {
        Map<String, Object> sortParams = new TreeMap<>(params);
        Set<Map.Entry<String, Object>> set = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry<String, Object> entry : set) {
            valueSb.append(entry.getKey())
                    .append("=")
                    .append(Objects.isNull(entry.getValue()) ? "" : entry.getValue())
                    .append("&");
        }
        String value = valueSb.toString().substring(0, valueSb.toString().length() - 1) + token;
        return DigestUtils.md5Hex(value).toUpperCase();
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }


    @Override
    public Rtb rtb() {
        return Rtb.WifiOcpx;
    }
}
