package com.bxm.adscounter.rtb.common.impl.xiaobu;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

import java.util.Map;

/**
 * @author tangxiao
 * @date 2023-03-13
 * @since 1.0
 */
@Slf4j
public class XiaobuRtbIntegration extends AbstractClickTrackerRtbIntegration {

    public XiaobuRtbIntegration(XiaobuConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.XiaoBu;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String eventType = request.getEventType();
        String clickId = request.getClickId();

        if (StringUtils.isBlank(eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }

        if (StringUtils.isBlank(clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickId'.");
        }

        Map<String, Object> params = Maps.newHashMap();
        params.put("event_name", eventType);
        params.put("click_id", clickId);
        params.put("event_time", String.valueOf(System.currentTimeMillis()));
        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

}
