package com.bxm.adscounter.rtb.common.impl.xiaomiocpx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

import java.util.Map;
import java.util.Objects;

/**
 * @author tangxiao
 * @date 2022-09-15
 * @since 1.0
 */
@Slf4j
public class XiaomiOcpxRtbIntegration extends AbstractClickTrackerRtbIntegration {


    public XiaomiOcpxRtbIntegration(XiaomiOcpxConfig config) {
        super(config, createHttpClient());
    }

    @Override
    public Rtb rtb() {
        return Rtb.XiaoMiOcpx;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = getFeedbackUrl();
        String eventType = request.getEventType();
        String callback = request.getClickId();

        if (StringUtils.isBlank(eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }
        if (StringUtils.isBlank(callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback'.");
        }

        KeyValueMap keyValueMap = request.getKeyValueMap();
        String imei  = keyValueMap.getFirst("imei");
        String oaid = keyValueMap.getFirst("oaid");
        Map<String, Object> params = Maps.newHashMap();
        params.put("callback", callback);
        params.put("conv_time", String.valueOf(System.currentTimeMillis()));
        params.put("convType", eventType);

        if (StringUtils.isNotBlank(imei)) {
            params.put("imei", imei);
        } else {
            params.put("oaid", oaid);
        }

        url = OkHttpUtils.appendParams(url, params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        Response response = JsonHelper.convert(body, Response.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (Objects.nonNull(response)) {
            feedbackResponse.setSuccess(response.getSuccess());
            feedbackResponse.setBody(response.getFailMsg());
        } else {
            feedbackResponse.setSuccess(false);
        }
        return feedbackResponse;
    }


    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    @Data
    public static class Response {
        private String code;
        private String failMsg;
        private Boolean success;
    }

}
