package com.bxm.adscounter.rtb.common.impl.youku;

import com.google.common.collect.Lists;
import org.apache.commons.collections.MapUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.bxm.adscounter.rtb.common.impl.youku.MapStrUtil.java
 * @created 2022-12-22 17:43:00
 * @modifier 拉拉
 * @updated 2022-12-22 17:43:00
 */
public class MapStrUtil {

    public static String toStr(Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        List<String> paramNameList = Lists.newArrayList();
        paramNameList.addAll(params.keySet());
        Collections.sort(paramNameList);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String key : paramNameList) {
            if (first) {
                first = false;
            } else {
                builder.append("&");
            }
            builder.append(key).append("=");
            Object value = params.get(key);
            String valueString = "";
            if (null != value) {
                valueString = String.valueOf(value);
            }
            builder.append(valueString);
        }
        return builder.toString();
    }
}

