package com.bxm.adscounter.rtb.common.listener;


import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.event.RtbDeductionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;

import java.util.Objects;
import java.util.Optional;

/**
 * rtb扣量监听 发送openlog日志
 * @author tangxiao
 * createDate:  2022/9/30
 */
@Slf4j
public class RtbDeductionEventListener implements EventListener<RtbDeductionEvent> {

    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RtbDeductionEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(RtbDeductionEvent event) {
        Rtb rtb = event.getRtb();
        FeedbackRequest request = event.getRequest();
        String deductionType = Optional.ofNullable(event.getDeductionType()).orElse(RtbDeductionEvent.DEDUCTION).toString();

        if (Objects.isNull(rtb) || Objects.isNull(request)) {
            return;
        }

        sendOpenLog(rtb, request, deductionType);
    }

    private void sendOpenLog(Rtb rtb, FeedbackRequest request, String deductionType) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        KeyValueMap map = new KeyValueMap();

        map.put(Common.RtbParam.P, Production.COMMON.getName());
        map.put(Common.RtbParam.MT, Common.Mt.rtbDeduction.original());
        map.put(Common.RtbParam.BXMID, keyValueMap.getFirst(Inads.Param.BXMID));
        map.put(Common.RtbParam.TYPE, keyValueMap.getFirst(Inads.Param.CONVERSION_TYPE));
        map.put(Common.RtbParam.UID, keyValueMap.getFirst(Inads.Param.UID));
        map.put(Common.RtbParam.TIME, System.currentTimeMillis());
        map.put(Common.RtbParam.ADID, keyValueMap.getFirst(Inads.Param.ADID));
        map.put(Common.RtbParam.TAGID, keyValueMap.getFirst(Inads.Param.TAGID));
        map.put(Common.RtbParam.CREATEID, keyValueMap.getFirst(Inads.Param.CREATEID));
        map.put(Common.RtbParam.IP, keyValueMap.getFirst(Inads.Param.IP));
        map.put(Common.RtbParam.UA, UrlHelper.urlEncode(keyValueMap.getFirst(Inads.Param.UA)));
        map.put(Common.Param.RTB_ID, rtb.getType());
        map.put(Common.Param.AD_GROUP_ID, request.getAdGroupId());
        map.putIfNotBlank(Common.RtbParam.REFER, UrlHelper.urlEncode(request.getReferrer()));
        map.putIfNotBlank(Common.RtbParam.IMEI_MD5, keyValueMap.getFirst(Inads.Param.IMEI_MD5));
        map.putIfNotBlank(Common.RtbParam.IDFA_MD5, keyValueMap.getFirst(Inads.Param.IDFA_MD5));
        map.putIfNotBlank(Common.RtbParam.ANDROIDID_MD5, keyValueMap.getFirst(Inads.Param.ANDROIDID_MD5));
        map.putIfNotBlank(Common.RtbParam.OAID, keyValueMap.getFirst(Inads.Param.OAID));
        map.putIfNotBlank(Common.RtbParam.OAID_MD5, keyValueMap.getFirst(Inads.Param.OAID_MD5));
        map.putIfNotBlank("deduction_type", deductionType);

        String openLogRequestUri = map.createOpenLogRequestUri(properties.getOpenLogRequestDomain());
        openLogClient.asyncRequest(openLogRequestUri);
    }
}
