package com.bxm.adscounter.rtb.common.mapper;

import com.bxm.adscounter.rtb.common.data.DorisAdGroupConversionData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupHourlyData;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author tangxiao
 * @since 2023-01-06
 */
@Repository
public interface DorisMapper {

     /**
      *
      * @param positionId
      * @param adGroupId
      * @param thedate 格式 yyyy-MM-dd
      * @param thehour 格式 HH
      * @return
      */
     List<DorisAdGroupHourlyData> getAdGroupHourlyData(@Param("positionId") String positionId,
                                                       @Param("adGroupId") String adGroupId,
                                                       @Param("thedate") String thedate,
                                                       @Param("thehour") String thehour);

     /**
      *
      * @param positionId
      * @param adGroupId
      * @param thedate 格式 yyyyMMdd
      * @param thehour 格式 yyyyMMddHH
      * @return
      */
     List<DorisAdGroupConversionData> getAdGroupConversionData(@Param("positionId") String positionId,
                                                               @Param("adGroupId") String adGroupId,
                                                               @Param("thedate") String thedate,
                                                               @Param("thehour") String thehour);
}
