package com.bxm.adscounter.rtb.common.service;

import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author allen
 * @date 2022-07-12
 * @since 1.0
 */
public class DefaultPositionRtbService implements PositionRtbService {

    private Fetcher fetcher;

    @Autowired
    public void setFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public PositionRtb get(String positionId) {
        return fetcher.hfetch(new TargetFactory<PositionRtb>()
                .keyGenerator(TicketKeyGenerator.rtbHeadTicket())
                .field(positionId)
                .skipNativeCache(true)
                .cls(PositionRtb.class)
                .build());
    }

    @Override
    public List<PositionRtb> getAll() {
        Map<String, PositionRtb> map =  fetcher.hfetchall(new TargetFactory<PositionRtb>()
                .keyGenerator(TicketKeyGenerator.rtbHeadTicket())
                .skipNativeCache(true)
                .cls(PositionRtb.class)
                .build());
        if (Objects.nonNull(map)) {
            return new ArrayList<>(map.values());
        }
        return new ArrayList<>();
    }
}
