package com.bxm.adscounter.rtb.common.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2022-10-31
 * @since 1.0
 */
public class InadsExtValueUtils {

    /**
     * 将指定字符串转换成键值对，兼容 JSON、k:v,k:v 两种格式。
     *
     * @param extJson 字符串
     * @return 键值对
     */
    public static Map<String, Object> parse(String extJson) {
        Map<String, Object> ext;
        try {
            ext = StringUtils.isNotBlank(extJson) ? JSONObject.parseObject(extJson) : new JSONObject();
        } catch (Exception e) {
            // 前端存在 k:v,k:v 的格式，需要兼容处理。
            ext = new JSONObject();
            String[] arrays = StringUtils.split(extJson, ",");
            if (Objects.nonNull(arrays)) {
                for (String array : arrays) {
                    String[] item = StringUtils.split(array, ":");
                    if (item.length >= 2) {
                        ext.put(item[0], item[1]);
                    }
                }
            }
        }
        return ext;
    }
}
