/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public interface ClickTracker {
    public static final String EMPTY_APP = "-";
    public static final String EMPTY_AD_GROUP_ID = "0";
    public static final String NULL_STRING = "NULL";

    public Rtb rtb();

    default public String getClickIdParameterNameOnReferrer() {
        return "click_id";
    }

    default public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    default public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String clickIdParamNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        if (Objects.isNull(clickIdParamNameOnReferrer)) {
            return null;
        }
        String ref = clickEventLog.getRef();
        return UrlHelper.getFirstValueOfParamName((String)ref, (String)clickIdParamNameOnReferrer);
    }

    default public boolean forceSaveClickTracker() {
        return false;
    }

    public void saveClickTracker(KeyValueMap var1);

    public KeyValueMap getClickTracker(String var1);

    default public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = request.getClickId();
        if (StringUtils.isBlank((String)clickId)) {
            clickId = (String)queryParams.getFirst((Object)this.getClickIdParameterNameOnReferrer());
        }
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    default public String getApp(KeyValueMap keyValueMap) {
        return EMPTY_APP;
    }

    default public KeyGenerator createKey(String clickId) {
        Rtb rtb = this.rtb();
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "click", "tracker", rtb.getType(), clickId});
    }

    default public String[] getMissingAdGroupIdList() {
        return null;
    }

    default public String fixAdGroupIdIfInvalid(String adGroupId) {
        if (StringUtils.isBlank((String)adGroupId) || StringUtils.equalsIgnoreCase((String)adGroupId, (String)NULL_STRING)) {
            return EMPTY_AD_GROUP_ID;
        }
        Object[] missingAdGroupIdList = this.getMissingAdGroupIdList();
        if (null != missingAdGroupIdList && ArrayUtils.contains((Object[])missingAdGroupIdList, (Object)adGroupId)) {
            return EMPTY_AD_GROUP_ID;
        }
        return adGroupId;
    }
}

