/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;

@Aspect
public class RtbIntegrationAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(RtbIntegrationAspect.class);
    private final List<RtbFeedbackInterceptor> interceptors;

    public RtbIntegrationAspect(List<RtbFeedbackInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Pointcut(value="this(com.bxm.adscounter.rtb.common.RtbIntegration) && execution(com.bxm.adscounter.rtb.common.feedback.FeedbackResponse doFeedback(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target;
        if (log.isDebugEnabled()) {
            log.debug("execute: {}", this.getClass());
        }
        if (!((target = point.getTarget()) instanceof RtbIntegration)) {
            return point.proceed();
        }
        if (CollectionUtils.isEmpty(this.interceptors)) {
            return point.proceed();
        }
        RtbIntegration integration = (RtbIntegration)target;
        FeedbackRequest request = null;
        FeedbackResponse response = null;
        try {
            Object[] args = point.getArgs();
            if (ArrayUtils.isEmpty((Object[])args)) {
                return point.proceed();
            }
            Object arg = args[0];
            if (!(arg instanceof FeedbackRequest)) {
                return point.proceed();
            }
            request = (FeedbackRequest)arg;
            for (RtbFeedbackInterceptor rtbFeedbackInterceptor : this.interceptors) {
                try {
                    rtbFeedbackInterceptor.doRequest(integration, request);
                }
                catch (Exception e) {
                    log.error("doRequest: ", (Throwable)e);
                }
            }
            Object proceed = point.proceed();
            if (!(proceed instanceof FeedbackResponse)) {
                return proceed;
            }
            response = (FeedbackResponse)proceed;
            if (response.isSuccess()) {
                for (RtbFeedbackInterceptor interceptor : this.interceptors) {
                    try {
                        interceptor.doSuccess(integration, request, response);
                    }
                    catch (Exception e) {
                        log.error("doSuccess: ", (Throwable)e);
                    }
                }
            } else {
                for (RtbFeedbackInterceptor interceptor : this.interceptors) {
                    try {
                        interceptor.doFail(integration, request, response);
                    }
                    catch (Exception e) {
                        log.error("doFail: ", (Throwable)e);
                    }
                }
            }
            return proceed;
        }
        catch (Throwable throwable) {
            for (RtbFeedbackInterceptor interceptor : this.interceptors) {
                try {
                    interceptor.doException(integration, request, response, throwable);
                }
                catch (Exception exception) {
                    log.error("doException: ", (Throwable)exception);
                }
            }
            throw throwable;
        }
    }
}

