/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerInterceptor
implements RtbFeedbackInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggerInterceptor.class);

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        log.info("Success - [{}] - {} - {}", new Object[]{integration.rtb(), request.getRequestUrl(), response.getBody()});
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        log.info("Fail - [{}] - {} - {}", new Object[]{integration.rtb(), request.getRequestUrl(), response.getBody()});
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        String requestUrl = Optional.ofNullable(request).map(FeedbackRequest::getRequestUrl).orElse("?");
        FailType failType = null;
        if (throwable instanceof RtbIntegrationException) {
            RtbIntegrationException exception = (RtbIntegrationException)throwable;
            failType = exception.getFailType();
        }
        String fail = Optional.ofNullable(failType).map(Enum::name).orElse("?");
        log.error("Exception - [{}] - {} - {} - {}", new Object[]{integration.rtb(), fail, requestUrl, throwable.getMessage()});
    }
}

