/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.service.AbstractFeedbackService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.extension.client.HttpClientOpenLogClient;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbConversionOpenLogInterceptor
implements RtbFeedbackInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RtbConversionOpenLogInterceptor.class);
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RtbConversionOpenLogInterceptor(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        this.sendOpenLog(integration, request, response, 1, null);
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        this.sendOpenLog(integration, request, response, 2, null);
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        this.sendOpenLog(integration, request, response, 3, throwable);
    }

    private void sendOpenLog(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, int rtbSc, Throwable throwable) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        PositionRtb positionRtb = request.getConfig();
        KeyValueMap map = new KeyValueMap();
        String msg = "";
        if (Objects.nonNull(throwable)) {
            String name = "";
            if (throwable instanceof RtbIntegrationException) {
                RtbIntegrationException e = (RtbIntegrationException)throwable;
                name = e.getFailType().name();
            }
            msg = StringUtils.substring((String)(name + " - " + throwable.getMessage()), (int)0, (int)255);
        }
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.rtbConversion.original());
        map.put("bxmid", (String)keyValueMap.getFirst((Object)"bxmid"));
        map.put("type", (String)keyValueMap.getFirst((Object)"conversion_type"));
        map.put("uid", (String)keyValueMap.getFirst((Object)"uid"));
        map.put("time", (Object)System.currentTimeMillis());
        map.put("adid", (String)keyValueMap.getFirst((Object)"adid"));
        map.put("tagid", (String)keyValueMap.getFirst((Object)"tagid"));
        map.put("createid", (String)keyValueMap.getFirst((Object)"createid"));
        map.put("ip", (String)keyValueMap.getFirst((Object)"ip"));
        map.put("ua", (String)keyValueMap.getFirst((Object)"ua"));
        map.put("rtb_id", (Object)integration.rtb().getType());
        map.put("ad_group_id", request.getAdGroupId());
        map.put("rtb_status", (Object)rtbSc);
        map.putIfNotBlank("refer", request.getReferrer());
        map.putIfNotBlank("rtb_request_uri", request.getRequestUrl());
        map.putIfNotBlank("rtb_event_type", request.getEventType());
        map.putIfNotBlank("rtb_req_body", request.getRequestBody());
        map.putIfNotBlank("rtb_res_body", Optional.ofNullable(response).map(FeedbackResponse::getBody).orElse(""));
        map.putIfNotBlank("rtb_res_msg", msg);
        map.putIfNotBlank("imei_md5", (String)keyValueMap.getFirst((Object)"imei_md5"));
        map.putIfNotBlank("idfa_md5", (String)keyValueMap.getFirst((Object)"idfa_md5"));
        map.putIfNotBlank("androidid_md5", (String)keyValueMap.getFirst((Object)"androidid_md5"));
        map.putIfNotBlank("oaid", (String)keyValueMap.getFirst((Object)"oaid"));
        map.putIfNotBlank("oaid_md5", (String)keyValueMap.getFirst((Object)"oaid_md5"));
        map.putIfNotBlank("action_time", (String)keyValueMap.getFirst((Object)"time"));
        map.putIfNotBlank("action_type", (String)Optional.ofNullable(request.getActionType()).map(ActionType::getValue).orElse(null));
        map.putIfNotBlank("smart_conv_type", Optional.ofNullable(request.getSmartConvType()).map(SmartConvType::getValue).orElse(SmartConvType.NONE.getValue()));
        map.putIfNotBlank("rank_by_activity", AbstractFeedbackService.getAcquiredRankByActivity(keyValueMap));
        map.putIfNotBlank("retry_flag", request.getRetryTimes() > 0 ? "1" : "0");
        if (positionRtb != null) {
            map.put("feedback_mode", (Object)positionRtb.getFeedbackMode());
        }
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain(), true);
        if (Objects.equals(7, integration.rtb().getType())) {
            log.info("UC debug: {}", (Object)openLogRequestUri);
        }
        this.openLogClient.asyncRequest(openLogRequestUri);
    }

    public static void main(String[] args) throws IOException {
        HttpClientOpenLogClient clientOpenLogClient = HttpClientOpenLogClient.builder().build();
        String testUrl = "http://openlog-inner.bianxianmao.com/common/s.gif?p={abc}";
        new HttpGet(testUrl);
    }
}

