/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.autoconfigure;

import com.bxm.adscounter.rtb.common.autoconfigure.RtbJedisProperties;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

@EnableConfigurationProperties(value={RtbJedisProperties.class})
public class RtbJedisAutoConfiguration {
    private final RtbJedisProperties properties;

    public RtbJedisAutoConfiguration(RtbJedisProperties properties) {
        this.properties = properties;
    }

    @Bean(name={"rtbJedisPool"})
    public JedisPool rtbJedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.properties, this.properties.getHost(), this.properties.getPort(), this.properties.getTimeout(), this.properties.getPassword(), this.properties.getDatabase());
    }

    @Bean(name={"rtbJedisFetcher"})
    public JedisFetcher rtbJedisFetcher() {
        return new JedisFetcher(this.rtbJedisPool());
    }

    @Bean(name={"rtbJedisUpdater"})
    public JedisUpdater rtbJedisUpdater() {
        return new JedisUpdater(this.rtbJedisPool());
    }

    @Bean(name={"rtbJedisCounter"})
    public JedisCounter rtbJedisCounter() {
        return new JedisCounter(this.rtbJedisPool());
    }
}

