/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import com.bxm.warcar.zk.ZkClientHolder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public abstract class AbstractDistributedControlScheduler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractDistributedControlScheduler.class);
    private final JedisPool jedisPool;
    private InterProcessLock lock;

    public AbstractDistributedControlScheduler(JedisPool jedisPool, ZkClientHolder zkClientHolder, String dimension, String namespace) {
        this.jedisPool = jedisPool;
        if (Objects.nonNull(zkClientHolder)) {
            String path = namespace + dimension;
            this.lock = new InterProcessMutex(zkClientHolder.get(), path);
        }
    }

    protected abstract void doRun();

    @Override
    public void run() {
        boolean acquired = true;
        try {
            if (Objects.nonNull(this.lock)) {
                acquired = this.lock.acquire(1L, TimeUnit.NANOSECONDS);
            }
            if (acquired) {
                this.doRun();
            }
        }
        catch (Exception e) {
            log.error("doRun: ", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(this.lock) && acquired) {
                try {
                    this.lock.release();
                }
                catch (Exception e) {
                    log.error("release: ", (Throwable)e);
                }
            }
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

