/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.DeductionControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.LocalDateTimeUtils;
import com.bxm.adscounter.rtb.common.control.deduction.ConversionLevel;
import com.bxm.adscounter.rtb.common.control.deduction.DeductionControl;
import com.bxm.adscounter.rtb.common.control.deduction.DeductionControlConfig;
import com.bxm.adscounter.rtb.common.control.deduction.RedisDeductionControlImpl;
import com.bxm.adscounter.rtb.common.event.RtbDeductionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.SafeMapHelper;
import com.bxm.warcar.utils.TypeHelper;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.LocalTime;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

@Deprecated
public class DefaultDeductionControlRtbIntegrationImpl
implements DeductionControlRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeductionControlRtbIntegrationImpl.class);
    private final ScheduledThreadPoolExecutor refreshExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("refresh"));
    private final ConcurrentHashMap<String, String> referenced = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<String>> mapping = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DeductionControl> controlExecutors = new ConcurrentHashMap();
    private final JedisPool jedisPool;
    private final PositionRtbService service;
    private MeterRegistry registry;
    private final AsyncEventPark asyncEventPark;

    public DefaultDeductionControlRtbIntegrationImpl(JedisPool jedisPool, PositionRtbService service, AsyncEventPark asyncEventPark) {
        this.jedisPool = jedisPool;
        this.service = service;
        this.asyncEventPark = asyncEventPark;
        this.refreshExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshControlForMapping();
            }
            catch (Exception e) {
                log.error("occur ex: ", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public boolean onFeedbackControl(RtbIntegration instance, FeedbackRequest request) {
        String adGroupId = request.getAdGroupId();
        if (StringUtils.isBlank((String)adGroupId)) {
            return false;
        }
        String tagId = (String)request.getKeyValueMap().getFirst((Object)"tagid");
        PositionRtb config = request.getConfig();
        if (Objects.isNull(config)) {
            return false;
        }
        PositionRtb.CvrControl hit = this.chooseCvrControl(config, adGroupId);
        if (Objects.isNull(hit)) {
            return false;
        }
        ConversionLevel convLevel = request.isDeepConversion() ? ConversionLevel.DEEP : ConversionLevel.SHALLOW;
        DeductionControl control = this.createIfNecessary(instance, tagId, adGroupId, hit, convLevel);
        control.push(JsonHelper.convert((Object)request));
        return true;
    }

    private PositionRtb.CvrControl chooseCvrControl(PositionRtb config, String adGroupId) {
        if (!config.isDeductionControl()) {
            return null;
        }
        List rateControls = config.getRateControls();
        if (CollectionUtils.isEmpty((Collection)rateControls)) {
            return null;
        }
        PositionRtb.CvrControl hit = null;
        for (PositionRtb.CvrControl cvrControl : rateControls) {
            String endTime;
            if (!cvrControl.isEnable()) continue;
            String theAdGroupId = cvrControl.getAdGroupId();
            String startTime = cvrControl.getStartTime();
            if (!this.isValidTime(startTime, endTime = cvrControl.getEndTime())) continue;
            if (StringUtils.isBlank((String)theAdGroupId)) {
                hit = cvrControl;
            }
            if (!StringUtils.equals((String)adGroupId, (String)theAdGroupId)) continue;
            hit = cvrControl;
            break;
        }
        return hit;
    }

    private boolean isValidTime(String startTime, String endTime) {
        LocalTime start = LocalDateTimeUtils.parseTime(startTime);
        LocalTime end = LocalDateTimeUtils.parseTime(endTime);
        if (Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        LocalTime now = LocalTime.now().withNano(0);
        return now.equals(start) || now.equals(end) || now.isAfter(start) && now.isBefore(end);
    }

    private DeductionControl createIfNecessary(final RtbIntegration instance, final String tagId, final String adGroupId, final PositionRtb.CvrControl hit, final ConversionLevel level) {
        final String key = ControlUtils.createKey(tagId, adGroupId, TypeHelper.castToString((Object)hit.getId()), hit.getStartTime(), hit.getEndTime(), level.name());
        return (DeductionControl)SafeMapHelper.get(this.controlExecutors, (Object)key, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<DeductionControl>(){

            public DeductionControl initializing() {
                double ratio = level == ConversionLevel.DEEP ? hit.getDeepCvr() : hit.getCvr();
                DeductionControlConfig deductionControlConfig = new DeductionControlConfig().setDimension(key).setRatio(ratio).setHitConfigId(hit.getId()).setLevel(level).setConsumer(new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)s, FeedbackRequest.class);
                        DefaultDeductionControlRtbIntegrationImpl.this.doFeedbackQuietly(instance, feedbackRequest);
                    }
                }).setDeductionConsumer(new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)s, FeedbackRequest.class);
                        DefaultDeductionControlRtbIntegrationImpl.this.asyncEventPark.post((EventObject)new RtbDeductionEvent(s, instance.rtb(), feedbackRequest, null));
                    }
                });
                RedisDeductionControlImpl deductionControl = new RedisDeductionControlImpl(DefaultDeductionControlRtbIntegrationImpl.this.jedisPool, deductionControlConfig, DefaultDeductionControlRtbIntegrationImpl.this.registry);
                ((Set)SafeMapHelper.get((Map)DefaultDeductionControlRtbIntegrationImpl.this.mapping, (Object)hit.getId(), HashSet::new)).add(key);
                String previous = DefaultDeductionControlRtbIntegrationImpl.this.referenced.put(tagId + adGroupId + level.name(), key);
                if (Objects.nonNull(previous)) {
                    log.info("Deduction control {} reference changed to {}", (Object)previous, (Object)key);
                }
                return deductionControl;
            }
        });
    }

    private void refreshControlForMapping() {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh deduction Controller...");
        }
        final HashSet<String> alive = new HashSet<String>(this.referenced.values());
        this.mapping.forEach(new BiConsumer<Long, Set<String>>(){

            @Override
            public void accept(Long id, Set<String> keys) {
                keys.forEach(key -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Checking {}", (Object)id, key);
                    }
                    String tagId = ControlUtils.splitKey(key)[0];
                    PositionRtb config = DefaultDeductionControlRtbIntegrationImpl.this.service.get(tagId);
                    if (Objects.isNull(config)) {
                        DefaultDeductionControlRtbIntegrationImpl.this.close(id, true, CloseReason.Illegal_Config);
                        return;
                    }
                    List controls = config.getRateControls();
                    if (CollectionUtils.isEmpty((Collection)controls)) {
                        DefaultDeductionControlRtbIntegrationImpl.this.close(id, true, CloseReason.No_Control);
                        return;
                    }
                    if (!config.isDeductionControl()) {
                        DefaultDeductionControlRtbIntegrationImpl.this.close(id, false, CloseReason.Not_Deduction);
                        return;
                    }
                    if (!alive.contains(key)) {
                        DefaultDeductionControlRtbIntegrationImpl.this.close(id, true, CloseReason.Dead);
                        return;
                    }
                    for (PositionRtb.CvrControl cfg : controls) {
                        String endTime;
                        if (!Objects.equals(id, cfg.getId())) continue;
                        if (!cfg.isEnable()) {
                            DefaultDeductionControlRtbIntegrationImpl.this.close(id, false, CloseReason.Disabled);
                            continue;
                        }
                        String startTime = cfg.getStartTime();
                        if (!DefaultDeductionControlRtbIntegrationImpl.this.isValidTime(startTime, endTime = cfg.getEndTime())) {
                            DefaultDeductionControlRtbIntegrationImpl.this.close(id, true, CloseReason.Invalid_Time);
                            continue;
                        }
                        DefaultDeductionControlRtbIntegrationImpl.this.refresh(id, cfg);
                    }
                });
            }
        });
    }

    private void refresh(Long id, PositionRtb.CvrControl cfg) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.forEach(key -> {
                DeductionControl control = this.controlExecutors.get(key);
                if (Objects.nonNull(control)) {
                    DeductionControlConfig config = control.getConfig();
                    if (config.getLevel() == ConversionLevel.DEEP) {
                        if (cfg.getDeepCvr() != config.getRatio()) {
                            if (log.isInfoEnabled()) {
                                log.info("[{} - {}] deep rate value {} changed to {}", new Object[]{id, key, config.getRatio(), cfg.getDeepCvr()});
                            }
                            config.setRatio(cfg.getDeepCvr());
                        }
                    } else if (cfg.getCvr() != config.getRatio()) {
                        if (log.isInfoEnabled()) {
                            log.info("[{} - {}] shallow rate value {} changed to {}", new Object[]{id, key, config.getRatio(), cfg.getCvr()});
                        }
                        config.setRatio(cfg.getCvr());
                    }
                }
            });
        }
    }

    private void close(Long id, final Boolean isDeleteRedisData, final CloseReason reason) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.removeIf(new Predicate<String>(){

                @Override
                public boolean test(String key) {
                    DeductionControl control = (DeductionControl)DefaultDeductionControlRtbIntegrationImpl.this.controlExecutors.get(key);
                    if (Objects.nonNull(control) && isDeleteRedisData.booleanValue()) {
                        control.delete();
                    }
                    DefaultDeductionControlRtbIntegrationImpl.this.controlExecutors.remove(key);
                    if (log.isInfoEnabled()) {
                        log.info("[{}] Close control: {} - {}", new Object[]{reason, key, control});
                    }
                    return true;
                }
            });
        }
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    private void doFeedbackQuietly(RtbIntegration instance, FeedbackRequest request) {
        try {
            instance.doFeedback(request, 1);
        }
        catch (RtbIntegrationException e) {
            log.error("doFeedbackQuietly: ", (Throwable)e);
        }
    }

    static enum CloseReason {
        Illegal_Config,
        No_Control,
        Not_Deduction,
        Dead,
        Disabled,
        Invalid_Time;

    }
}

