/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.cpa;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.control.cpa.PreSummaryFeedbackHelper;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class SummaryCpaControlImpl
implements CpaControl {
    private static final Logger log = LoggerFactory.getLogger(SummaryCpaControlImpl.class);
    private static final int ONE_DAY_SEC = TypeHelper.castToInt((Object)Duration.ofDays(1L).getSeconds());
    private static final int MONTH_DAYS_SEC = TypeHelper.castToInt((Object)Duration.ofDays(30L).getSeconds());
    private final Counter counter;
    private final Fetcher fetcher;
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;
    private final JedisPool jedisPool;
    private final PreSummaryFeedbackHelper preSummaryFeedbackHelper;

    public SummaryCpaControlImpl(Counter counter, Fetcher fetcher, RtbProperties properties, OpenLogClient openLogClient, JedisPool jedisPool, PreSummaryFeedbackHelper preSummaryFeedbackHelper) {
        this.counter = counter;
        this.fetcher = fetcher;
        this.properties = properties;
        this.openLogClient = openLogClient;
        this.jedisPool = jedisPool;
        this.preSummaryFeedbackHelper = preSummaryFeedbackHelper;
    }

    @Override
    public boolean isFeedback(FeedbackRequest feedbackRequest, RtbIntegration integration) {
        KeyGenerator redisKey;
        Long cpaBalance;
        boolean isFeedback;
        String adGroupId;
        PositionRtb positionRtb = feedbackRequest.getConfig();
        KeyValueMap keyValueMap = feedbackRequest.getKeyValueMap();
        if (!positionRtb.isFeedbackModeSummaryCpa()) {
            return true;
        }
        if (!this.isConversionValid(keyValueMap)) {
            return false;
        }
        Integer rtbTargetCpa = positionRtb.getRtbTargetCpa();
        if (rtbTargetCpa == null) {
            return true;
        }
        String positionId = positionRtb.getPositionId();
        if (this.preFeedbackIfNeeded(positionRtb, positionId, adGroupId = feedbackRequest.getAdGroupId())) {
            return true;
        }
        int ocpaOfferPrice = NumberUtils.toInt((String)((String)keyValueMap.getFirst((Object)"ocpa_offer_price")));
        if (!Objects.equals(rtbTargetCpa, 0)) {
            int limitOfferPrice = 3 * rtbTargetCpa;
            ocpaOfferPrice = Math.min(ocpaOfferPrice, limitOfferPrice);
        }
        boolean bl = isFeedback = (cpaBalance = this.counter.hincrementByAndGet(redisKey = this.hashRtbCpa(positionId, adGroupId), "cpa_balance", (long)ocpaOfferPrice)) >= (long)rtbTargetCpa.intValue();
        if (isFeedback) {
            this.counter.hincrementByAndGet(redisKey, "cpa_balance", (long)(-rtbTargetCpa.intValue()));
        } else {
            this.pushConversion(feedbackRequest);
        }
        this.counter.hincrementByAndGet(redisKey, "summary_cpa", (long)ocpaOfferPrice);
        this.counter.expire(redisKey, ONE_DAY_SEC);
        this.sendOpenLog(positionId, adGroupId, positionRtb.getSourceType());
        return isFeedback;
    }

    @Override
    public List<FeedbackRequest> getOnConversionQueue(String positionId, List<String> adGroupIds, Integer size) {
        if (size <= 0) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackRequest> results = new ArrayList<FeedbackRequest>();
        block0: for (String adGroupId : adGroupIds) {
            String pop;
            String key = SummaryCpaControlImpl.listConversionQueue(positionId, adGroupId).generateKey();
            while (!StringUtils.isBlank((String)(pop = this.leftPop(key)))) {
                FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)pop, FeedbackRequest.class);
                results.add(feedbackRequest);
                if (results.size() < size) continue;
                continue block0;
            }
        }
        return results;
    }

    @Override
    public void pushConversion(FeedbackRequest feedbackRequest) {
        PositionRtb config = feedbackRequest.getConfig();
        if (config.isEnableSmartHosting()) {
            String adGroupId = feedbackRequest.getAdGroupId();
            String positionId = config.getPositionId();
            String data = JsonHelper.convert((Object)feedbackRequest);
            if (log.isInfoEnabled()) {
                log.info("\u7d2f\u52a0\u56de\u4f20\u6682\u5b58\u6570\u636e...{} - {}", (Object)positionId, (Object)adGroupId);
            }
            this.addConversion(positionId, adGroupId, data);
        }
    }

    @Override
    public long getConversionQueueLength(String positionId, List<String> adGroupIds) {
        long length = 0L;
        for (String adGroupId : adGroupIds) {
            String key = SummaryCpaControlImpl.listConversionQueue(positionId, adGroupId).generateKey();
            length += this.queueLength(key);
        }
        return length;
    }

    @Override
    public Long getSummaryCpaBalance(String positionId, String adGroupId) {
        KeyGenerator redisKey = this.hashRtbCpa(positionId, adGroupId);
        return (Long)Optional.ofNullable(this.fetcher.hfetch(redisKey, "cpa_balance", Long.class)).orElse(0L);
    }

    private boolean preFeedbackIfNeeded(PositionRtb positionRtb, String positionId, String adGroupId) {
        if (positionRtb.isPreSummaryFeedback()) {
            return this.preSummaryFeedbackHelper.needFeedback(positionRtb, adGroupId);
        }
        boolean isInitialized = this.counter.incrementAndGet(this.strInitSummary(positionId, adGroupId), MONTH_DAYS_SEC) > 1L;
        return !isInitialized;
    }

    public KeyGenerator strInitSummary(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "cpa_init", positionId, adGroupId});
    }

    public KeyGenerator hashRtbCpa(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "cpa", positionId, adGroupId, SummaryCpaControlImpl.getDate()});
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private void sendOpenLog(String positionId, String adGroupId, Integer rtbId) {
        Map rtbCpaData = this.fetcher.hfetchall(this.hashRtbCpa(positionId, adGroupId), Long.class);
        Long summaryCpa = Optional.ofNullable(rtbCpaData.get("summary_cpa")).orElse(0L);
        Long cpaBalance = Optional.ofNullable(rtbCpaData.get("cpa_balance")).orElse(0L);
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.RtbSummaryCpa.original());
        map.put("time", (Object)System.currentTimeMillis());
        map.put("tagid", positionId);
        map.put("rtb_id", (Object)rtbId);
        map.put("ad_group_id", adGroupId);
        map.put("summary_cpa", (Object)summaryCpa);
        map.put("summary_cpa_balance", (Object)cpaBalance);
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(openLogRequestUri);
    }

    public boolean isConversionValid(KeyValueMap map) {
        return StringUtils.equalsIgnoreCase((String)((String)map.getFirst((Object)"conversion_valid")), (String)"1");
    }

    static KeyGenerator listConversionQueue(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "summary_feedback", "CONV_QUEUE", SummaryCpaControlImpl.getHour(), positionId, adGroupId});
    }

    private static String getHour() {
        return DateHelper.format((String)"yyyyMMddHH");
    }

    private void addConversion(String positionId, String adGroupId, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = SummaryCpaControlImpl.listConversionQueue(positionId, adGroupId).generateKey();
            jedis.lpush(key, new String[]{data});
            jedis.expire(key, 86400);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String leftPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("lpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long queueLength(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            log.error("lpop: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    static interface Field {
        public static final String CPA_BALANCE = "cpa_balance";
        public static final String SUMMARY_CPA = "summary_cpa";
    }
}

