/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.cpa;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupConversionData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupHourlyData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouDataFetcher;
import com.bxm.adscounter.rtb.common.mapper.DorisMapper;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.adsprod.facade.ticket.rtb.SummarySmartHostingConfig;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class SummarySmartHostingScheduler {
    private static final Logger log = LoggerFactory.getLogger(SummarySmartHostingScheduler.class);
    private final PositionRtbService positionRtbService;
    private final KuaishouDataFetcher kuaishouDataFetcher;
    private final DorisMapper dorisMapper;
    private final CpaControl cpaControl;
    private final RtbIntegrationFactory rtbIntegrationFactory;
    private final Updater updater;
    private final Counter counter;
    private final MessageSender messageSender;

    public SummarySmartHostingScheduler(PositionRtbService positionRtbService, KuaishouDataFetcher kuaishouDataFetcher, DorisMapper dorisMapper, CpaControl cpaControl, RtbIntegrationFactory rtbIntegrationFactory, Updater updater, Counter counter, RtbProperties properties) {
        this.positionRtbService = positionRtbService;
        this.kuaishouDataFetcher = kuaishouDataFetcher;
        this.dorisMapper = dorisMapper;
        this.cpaControl = cpaControl;
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.updater = updater;
        this.counter = counter;
        this.messageSender = new DingDingMessageSender(properties.getNotifyDingtalkUrl());
    }

    @Scheduled(cron="0 10,20,30,40,50,55 * * * ? ")
    public void execute() {
        log.info("\u3010smart hosting\u3011\u6267\u884c\u5f00\u59cb\uff01");
        long start = System.currentTimeMillis();
        List availablePositionRtb = this.positionRtbService.getAll().stream().filter(PositionRtb::isEnableSmartHosting).collect(Collectors.toList());
        for (PositionRtb positionRtb : availablePositionRtb) {
            String positionId = positionRtb.getPositionId();
            try {
                List<ComputeParameter> computeParameters;
                List<SummarySmartHostingConfig.Config> adGroupConf;
                if (log.isInfoEnabled()) {
                    log.info("[{}] rtb-summary smart hosting scheduler started.................", (Object)positionId);
                }
                if (CollectionUtils.isEmpty(adGroupConf = this.getAdGroupConf(positionRtb))) continue;
                try {
                    computeParameters = this.getComputeParameterList(positionRtb, adGroupConf);
                }
                catch (Exception e) {
                    log.error("getComputeParameterList occur error", (Throwable)e);
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info("[{}] computeParameters : {}", (Object)positionId, (Object)JSON.toJSONString(computeParameters));
                }
                if (CollectionUtils.isEmpty(computeParameters)) continue;
                Set<String> confAdGroupIds = adGroupConf.stream().map(SummarySmartHostingConfig.Config::getAdGroupId).filter(adGroupId -> !this.isAccountDimension((String)adGroupId)).collect(Collectors.toSet());
                RtbIntegration integration = this.rtbIntegrationFactory.get(Rtb.of(positionRtb.getSourceType()));
                this.smartHostingPlusAndSwitch(computeParameters, confAdGroupIds, integration, positionId);
                this.saveFetchInfo(computeParameters, positionId);
                if (!log.isInfoEnabled()) continue;
                log.info("[{}] rtb-summary smart hosting scheduler end!", (Object)positionId);
            }
            catch (Exception e) {
                log.error(String.format("[%s] execute occur error", positionId), (Throwable)e);
            }
        }
        log.info("\u3010smart hosting\u3011\u672c\u6b21\u8c03\u5ea6\u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void saveFetchInfo(List<ComputeParameter> computeParameters, String positionId) {
        for (ComputeParameter computeParameter : computeParameters) {
            for (SmartHostingInfoFieldEnum fieldEnum : SmartHostingInfoFieldEnum.values()) {
                this.updater.hupdate(SummarySmartHostingScheduler.hashAdGroupHourInfo(positionId, computeParameter.getAdGroupId()), fieldEnum.getFieldName(), Optional.ofNullable(fieldEnum.getFetchFunction().apply(computeParameter)).orElse(fieldEnum.getDefaultValue()));
                this.updater.expire(SummarySmartHostingScheduler.hashAdGroupHourInfo(positionId, computeParameter.getAdGroupId()), 86400);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smartHostingPlusAndSwitch(List<ComputeParameter> computeParameters, Set<String> confAdGroupIds, RtbIntegration integration, String positionId) {
        for (ComputeParameter computeParameter : computeParameters) {
            int plusCount;
            List<String> activeAdGroupIds = this.getActiveAdGroupIds(computeParameter, confAdGroupIds);
            if (CollectionUtils.isEmpty(activeAdGroupIds)) continue;
            this.updater.hupdate(SummarySmartHostingScheduler.hashAdGroupHourInfo(positionId, computeParameter.adGroupId), "plusQueueLength", (Object)this.cpaControl.getConversionQueueLength(positionId, activeAdGroupIds));
            if (computeParameter.getShouldIntercept().booleanValue() || computeParameter.getEnableBreaker().booleanValue() || (plusCount = computeParameter.getNeedPlusCount()) <= 0) continue;
            List<FeedbackRequest> feedbackRequests = this.cpaControl.getOnConversionQueue(positionId, activeAdGroupIds, plusCount);
            if (plusCount > feedbackRequests.size()) {
                computeParameter.setEnableSmartHosting(true);
                for (String activeAdGroupId : activeAdGroupIds) {
                    this.switchSmartHosting(positionId, activeAdGroupId);
                }
            }
            for (FeedbackRequest feedbackRequest : feedbackRequests) {
                try {
                    log.info("[{} - {}] \u667a\u80fd\u6258\u7ba1\u8865\u91cf\u56de\u4f20\u4e2d...", (Object)positionId, (Object)computeParameter.getAdGroupId());
                    feedbackRequest.setSmartConvType(SmartConvType.SMART_HOSTING_QUEUE);
                    integration.doFeedback(feedbackRequest, 1);
                }
                catch (RtbIntegrationException e) {
                    log.error("RTB smart hosting. plus feedback occur exception", (Throwable)e);
                }
                finally {
                    this.counter.hincrementAndGet(SummarySmartHostingScheduler.hashAdGroupHourInfo(positionId, computeParameter.adGroupId), "plusNum");
                }
            }
        }
    }

    private List<String> getActiveAdGroupIds(ComputeParameter computeParameter, Set<String> confAdGroupIds) {
        if (this.isAccountDimension(computeParameter.getAdGroupId())) {
            List<String> activeAdGroupIds = computeParameter.getFetchKuaishouAdGroupIds().stream().filter(kuaishouAdGroupId -> !confAdGroupIds.contains(kuaishouAdGroupId)).collect(Collectors.toList());
            activeAdGroupIds.add("0");
            return activeAdGroupIds;
        }
        return Lists.newArrayList((Object[])new String[]{computeParameter.getAdGroupId()});
    }

    private void switchSmartHosting(String positionId, String adGroupId) {
        Long summaryCpaBalance = this.cpaControl.getSummaryCpaBalance(positionId, adGroupId);
        if (summaryCpaBalance == 0L) {
            return;
        }
        this.updater.update(SummarySmartHostingScheduler.strAlgSmartHostingSwitch(positionId, adGroupId), (Object)1, Math.toIntExact(Duration.ofMinutes(15L).getSeconds()));
        this.sendDingDing(String.format("\u5e7f\u544a\u4f4d:%s\uff0c\u5e7f\u544a\u7ec4:%s \u5207\u6362\u4e3a\u667a\u80fd\u6258\u7ba1\u7b97\u6cd5!", positionId, adGroupId));
    }

    private List<ComputeParameter> getComputeParameterList(PositionRtb positionRtb, List<SummarySmartHostingConfig.Config> adGroupConf) {
        List<AdGroupData> kuaishouAdGroupDataList;
        Parameter parameter = Parameter.builder().advertiserId(positionRtb.getCustomerId()).tagId(positionRtb.getPositionId()).needFetchKuaishouCpa(true).build();
        try {
            kuaishouAdGroupDataList = this.kuaishouDataFetcher.fetchCurrentHourData(parameter);
            if (Objects.isNull(kuaishouAdGroupDataList)) {
                throw new DataFetchFailException(String.format("kuaishou fetch data is null. positionId: %s", positionRtb.getPositionId()));
            }
        }
        catch (DataFetchFailException e) {
            log.warn("data fetch fail : {}", (Object)e.getMessage());
            return null;
        }
        Map<String, AdGroupData> kuaishouAdGroupDataMap = kuaishouAdGroupDataList.stream().filter(data -> StringUtils.isNotBlank((String)data.getAdGroupId())).collect(Collectors.toMap(AdGroupData::getAdGroupId, d -> d));
        List<DorisAdGroupHourlyData> adGroupHourlyData = this.dorisMapper.getAdGroupHourlyData(positionRtb.getPositionId(), null, DateHelper.format((String)"yyyy-MM-dd"), DateHelper.format((String)"HH"));
        List<DorisAdGroupConversionData> adGroupConversionData = this.dorisMapper.getAdGroupConversionData(positionRtb.getPositionId(), null, DateHelper.format((String)"yyyyMMdd"), SummarySmartHostingScheduler.getHour());
        Map<String, Long> dorisAdGroupConversionMap = adGroupConversionData.stream().collect(Collectors.toMap(data -> data.getAdGroupId(), data -> data.getSendValidPv()));
        Map<String, BigDecimal> dorisAdGroupIncomeMap = adGroupHourlyData.stream().collect(Collectors.toMap(data -> data.getAdGroupId(), data -> data.getIncome()));
        log.info("positionId: {},  kuaishou list :{}", (Object)positionRtb.getPositionId(), (Object)JSON.toJSONString(kuaishouAdGroupDataList));
        log.info("positionId: {},  doris income list :{}", (Object)positionRtb.getPositionId(), (Object)JSON.toJSONString(adGroupHourlyData));
        log.info("positionId: {},  doris conversion list :{}", (Object)positionRtb.getPositionId(), (Object)JSON.toJSONString(adGroupConversionData));
        return adGroupConf.stream().map(adGroupConfig -> this.buildComputeParameter((SummarySmartHostingConfig.Config)adGroupConfig, kuaishouAdGroupDataList, kuaishouAdGroupDataMap, dorisAdGroupConversionMap, dorisAdGroupIncomeMap, positionRtb)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ComputeParameter buildComputeParameter(SummarySmartHostingConfig.Config config, List<AdGroupData> kuaishouAdGroupDataList, Map<String, AdGroupData> kuaishouAdGroupDataMap, Map<String, Long> dorisAdGroupConversionMap, Map<String, BigDecimal> dorisAdGroupIncomeMap, PositionRtb positionRtb) {
        String adGroupId = config.getAdGroupId();
        BigDecimal charge = Optional.ofNullable(this.getKuaishouCharge(adGroupId, kuaishouAdGroupDataList, kuaishouAdGroupDataMap)).orElse(BigDecimal.ZERO);
        BigDecimal cpa = Optional.ofNullable(this.getCpa(config, kuaishouAdGroupDataMap, adGroupId)).orElse(BigDecimal.ZERO);
        Double minRoi = config.getMinRoi();
        Double excessRatio = config.getExcessRatio();
        BigDecimal income = Optional.ofNullable(this.getDorisIncome(adGroupId, dorisAdGroupIncomeMap)).orElse(BigDecimal.ZERO);
        Long dorisConversionNum = Optional.ofNullable(this.getDorisConversionNum(adGroupId, dorisAdGroupConversionMap)).orElse(0L);
        Long kuaishouConversionNum = Optional.ofNullable(this.getKuaishouConversionNum(adGroupId, kuaishouAdGroupDataList, kuaishouAdGroupDataMap)).orElse(0L);
        log.info("[{} - {}] charge: {}, income: {}, dorisConversionNum: {}, kuaishouConversionNum: {}\uff0ccpa: {}", new Object[]{positionRtb.getPositionId(), config.getAdGroupId(), charge, income, dorisConversionNum, kuaishouConversionNum, cpa});
        Long activeConversionNum = this.getActiveConversionNum(kuaishouConversionNum, dorisConversionNum);
        BigDecimal roi = this.computeRoi(income, charge);
        boolean roiIntercept = this.isRoiIntercept(roi, minRoi);
        BigDecimal billCost = this.computeBillCost(charge, activeConversionNum);
        boolean billCostIntercept = this.isBillCostIntercept(billCost, excessRatio, cpa);
        Integer plusCount = this.computePlusCount(charge, excessRatio, cpa, activeConversionNum);
        boolean shouldIntercept = roiIntercept || billCostIntercept;
        boolean enableBreaker = this.isEnableBreaker(dorisConversionNum, kuaishouConversionNum, income, charge);
        return new ComputeParameter().setAdGroupId(adGroupId).setShouldIntercept(shouldIntercept).setNeedPlusCount(plusCount).setCharge(charge).setConversionNum(activeConversionNum).setBillCost(billCost).setRoi(roi).setEnableBreaker(enableBreaker).setFetchKuaishouAdGroupIds(this.getFetchKuaishouAdGroupIds(kuaishouAdGroupDataList, adGroupId)).setBillCostCpaFormula(this.getBillCostCpaFormula(billCost, cpa));
    }

    private boolean isBillCostIntercept(BigDecimal billCost, Double excessRatio, BigDecimal cpa) {
        if (billCost == null) {
            return true;
        }
        boolean billCostIntercept = billCost.compareTo(BigDecimal.valueOf(excessRatio).multiply(cpa)) <= 0;
        log.info("billCostIntercept({}) = {} <= {} * {}", new Object[]{billCostIntercept, billCost, excessRatio, cpa});
        return billCostIntercept;
    }

    private boolean isRoiIntercept(BigDecimal roi, Double minRoi) {
        if (roi == null) {
            return true;
        }
        boolean isRoiIntercept = roi.compareTo(BigDecimal.valueOf(minRoi)) <= 0;
        log.info("roiIntercept({})= {} <= {}", new Object[]{isRoiIntercept, roi, minRoi});
        return isRoiIntercept;
    }

    private boolean isEnableBreaker(Long dorisConversionNum, Long kuaishouConversionNum, BigDecimal income, BigDecimal charge) {
        long absoluteValue = Math.abs(dorisConversionNum - kuaishouConversionNum);
        if (dorisConversionNum == 0L) {
            return false;
        }
        double absoluteValueRatio = BigDecimal.valueOf(absoluteValue).divide(BigDecimal.valueOf(dorisConversionNum), 2, RoundingMode.HALF_UP).doubleValue();
        if (BigDecimal.ZERO.compareTo(charge) == 0) {
            return false;
        }
        double incomeChargeRatio = income.divide(charge, 6, RoundingMode.HALF_UP).doubleValue();
        boolean enableBreaker = absoluteValue > 5L || absoluteValueRatio > 0.2 || incomeChargeRatio > 1.5;
        log.info("enableBreaker({}) = {} > 5 || {} > 0.2 || {} > 1.5", new Object[]{enableBreaker, absoluteValue, absoluteValueRatio, incomeChargeRatio});
        return enableBreaker;
    }

    private List<String> getFetchKuaishouAdGroupIds(List<AdGroupData> kuaishouAdGroupDataList, String confAdGroupId) {
        if (this.isAccountDimension(confAdGroupId)) {
            return kuaishouAdGroupDataList.stream().map(AdGroupData::getAdGroupId).collect(Collectors.toList());
        }
        return null;
    }

    private BigDecimal getCpa(SummarySmartHostingConfig.Config config, Map<String, AdGroupData> kuaishouAdGroupDataMap, String adGroupId) {
        if (this.isAccountDimension(adGroupId)) {
            return BigDecimal.valueOf(config.getCpa());
        }
        AdGroupData kuaishouData = kuaishouAdGroupDataMap.get(adGroupId);
        return Optional.ofNullable(kuaishouData).map(AdGroupData::getCpa).orElse(null);
    }

    private BigDecimal getKuaishouCharge(String adGroupId, List<AdGroupData> kuaishouAdGroupData, Map<String, AdGroupData> kuaishouAdGroupDataMap) {
        if (this.isAccountDimension(adGroupId)) {
            if (kuaishouAdGroupData.isEmpty()) {
                return null;
            }
            return kuaishouAdGroupData.stream().map(AdGroupData::getCharge).reduce(BigDecimal::add).orElse(null);
        }
        AdGroupData data = kuaishouAdGroupDataMap.get(adGroupId);
        return Optional.ofNullable(data).map(AdGroupData::getCharge).orElse(null);
    }

    private Long getKuaishouConversionNum(String adGroupId, List<AdGroupData> kuaishouAdGroupData, Map<String, AdGroupData> kuaishouAdGroupDataMap) {
        if (this.isAccountDimension(adGroupId)) {
            if (kuaishouAdGroupData.isEmpty()) {
                return null;
            }
            return kuaishouAdGroupData.stream().map(AdGroupData::getConvNumByImpression).reduce(Long::sum).orElse(null);
        }
        AdGroupData data = kuaishouAdGroupDataMap.get(adGroupId);
        return Optional.ofNullable(data).map(AdGroupData::getConvNumByImpression).orElse(null);
    }

    private BigDecimal getDorisIncome(String adGroupId, Map<String, BigDecimal> dorisAdGroupIncomeMap) {
        if (this.isAccountDimension(adGroupId)) {
            if (dorisAdGroupIncomeMap.isEmpty()) {
                return null;
            }
            return dorisAdGroupIncomeMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return dorisAdGroupIncomeMap.getOrDefault(adGroupId, null);
    }

    private Long getActiveConversionNum(Long kuaishouConversionNum, Long dorisConversionNum) {
        boolean condition;
        boolean bl = condition = Math.abs(kuaishouConversionNum - dorisConversionNum) > 5L;
        if (condition) {
            return dorisConversionNum;
        }
        return kuaishouConversionNum;
    }

    private Integer computePlusCount(BigDecimal charge, Double excessRatio, BigDecimal cpa, Long activeConversionNum) {
        BigDecimal excessRatioCpaMultiply = BigDecimal.valueOf(excessRatio).multiply(cpa);
        if (BigDecimal.ZERO.compareTo(excessRatioCpaMultiply) == 0) {
            return 0;
        }
        long plusCount = charge.divide(excessRatioCpaMultiply, 2, RoundingMode.HALF_UP).subtract(BigDecimal.valueOf(activeConversionNum)).longValue();
        log.info("plusCount({}) = {} / ({} * {} - {})", new Object[]{plusCount, charge, excessRatio, cpa, activeConversionNum});
        return Math.toIntExact(plusCount);
    }

    static KeyGenerator strAlgSmartHostingSwitch(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RTB", "SMART", "HOSTING", "SWITCH", positionId, adGroupId});
    }

    static KeyGenerator hashAdGroupHourInfo(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "summary_feedback", "smart_hosting_info", SummarySmartHostingScheduler.getHour(), positionId, adGroupId});
    }

    private static String getHour() {
        return DateHelper.format((String)"yyyyMMddHH");
    }

    private BigDecimal computeBillCost(BigDecimal charge, Long conversionNum) {
        if (Objects.equals(conversionNum, 0L)) {
            return null;
        }
        BigDecimal billCost = charge.divide(BigDecimal.valueOf(conversionNum), 2, RoundingMode.HALF_UP);
        log.info("billCost({}) = {} / {}", new Object[]{billCost, charge, conversionNum});
        return billCost;
    }

    private BigDecimal computeRoi(BigDecimal income, BigDecimal charge) {
        if (charge.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal roi = income.divide(charge, 3, RoundingMode.HALF_UP);
        log.info("roi\uff08{}) = {} / {}", new Object[]{roi, income, charge});
        return roi;
    }

    Long getDorisConversionNum(String adGroupId, Map<String, Long> dorisAdGroupConversionMap) {
        if (this.isAccountDimension(adGroupId)) {
            if (dorisAdGroupConversionMap.isEmpty()) {
                return null;
            }
            return dorisAdGroupConversionMap.values().stream().reduce(0L, Long::sum);
        }
        return dorisAdGroupConversionMap.get(adGroupId);
    }

    private boolean isAccountDimension(String adGroupId) {
        return Objects.equals(adGroupId, "ACCOUNT");
    }

    private void sendDingDing(String msg) {
        try {
            log.info("\u9489\u9489\u53d1\u9001\u6d88\u606f\uff1a{}", (Object)msg);
            this.messageSender.send(new Message(msg));
        }
        catch (Exception e) {
            log.error("send: ", (Throwable)e);
        }
    }

    private List<SummarySmartHostingConfig.Config> getAdGroupConf(PositionRtb positionRtb) {
        String summarySmartHostingConf = positionRtb.getSummarySmartHostingConf();
        if (StringUtils.isBlank((String)summarySmartHostingConf)) {
            return null;
        }
        SummarySmartHostingConfig convert = (SummarySmartHostingConfig)JsonHelper.convert((String)summarySmartHostingConf, SummarySmartHostingConfig.class);
        SummarySmartHostingConfig.Config accountConf = convert.getAccountConf();
        List adGroupConf = Optional.ofNullable(convert.getAdGroupConf()).orElse(Lists.newArrayList());
        adGroupConf.add(accountConf);
        return adGroupConf;
    }

    private String getBillCostCpaFormula(BigDecimal billCost, BigDecimal cpa) {
        if (billCost == null) {
            return String.format("--/%s=--", cpa);
        }
        return cpa.compareTo(BigDecimal.ZERO) == 0 ? String.format("%s/0=--", billCost) : String.format("%s/%s=%s", billCost, cpa, billCost.divide(cpa, 2, RoundingMode.HALF_UP));
    }

    public static class ComputeParameter {
        String adGroupId;
        BigDecimal charge;
        Long conversionNum;
        BigDecimal billCost;
        BigDecimal roi;
        Boolean shouldIntercept;
        int needPlusCount;
        Boolean enableSmartHosting;
        List<String> fetchKuaishouAdGroupIds;
        Boolean enableBreaker;
        Integer hourPlus;
        String billCostCpaFormula;

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public BigDecimal getCharge() {
            return this.charge;
        }

        public Long getConversionNum() {
            return this.conversionNum;
        }

        public BigDecimal getBillCost() {
            return this.billCost;
        }

        public BigDecimal getRoi() {
            return this.roi;
        }

        public Boolean getShouldIntercept() {
            return this.shouldIntercept;
        }

        public int getNeedPlusCount() {
            return this.needPlusCount;
        }

        public Boolean getEnableSmartHosting() {
            return this.enableSmartHosting;
        }

        public List<String> getFetchKuaishouAdGroupIds() {
            return this.fetchKuaishouAdGroupIds;
        }

        public Boolean getEnableBreaker() {
            return this.enableBreaker;
        }

        public Integer getHourPlus() {
            return this.hourPlus;
        }

        public String getBillCostCpaFormula() {
            return this.billCostCpaFormula;
        }

        public ComputeParameter setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public ComputeParameter setCharge(BigDecimal charge) {
            this.charge = charge;
            return this;
        }

        public ComputeParameter setConversionNum(Long conversionNum) {
            this.conversionNum = conversionNum;
            return this;
        }

        public ComputeParameter setBillCost(BigDecimal billCost) {
            this.billCost = billCost;
            return this;
        }

        public ComputeParameter setRoi(BigDecimal roi) {
            this.roi = roi;
            return this;
        }

        public ComputeParameter setShouldIntercept(Boolean shouldIntercept) {
            this.shouldIntercept = shouldIntercept;
            return this;
        }

        public ComputeParameter setNeedPlusCount(int needPlusCount) {
            this.needPlusCount = needPlusCount;
            return this;
        }

        public ComputeParameter setEnableSmartHosting(Boolean enableSmartHosting) {
            this.enableSmartHosting = enableSmartHosting;
            return this;
        }

        public ComputeParameter setFetchKuaishouAdGroupIds(List<String> fetchKuaishouAdGroupIds) {
            this.fetchKuaishouAdGroupIds = fetchKuaishouAdGroupIds;
            return this;
        }

        public ComputeParameter setEnableBreaker(Boolean enableBreaker) {
            this.enableBreaker = enableBreaker;
            return this;
        }

        public ComputeParameter setHourPlus(Integer hourPlus) {
            this.hourPlus = hourPlus;
            return this;
        }

        public ComputeParameter setBillCostCpaFormula(String billCostCpaFormula) {
            this.billCostCpaFormula = billCostCpaFormula;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComputeParameter)) {
                return false;
            }
            ComputeParameter other = (ComputeParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNeedPlusCount() != other.getNeedPlusCount()) {
                return false;
            }
            Long this$conversionNum = this.getConversionNum();
            Long other$conversionNum = other.getConversionNum();
            if (this$conversionNum == null ? other$conversionNum != null : !((Object)this$conversionNum).equals(other$conversionNum)) {
                return false;
            }
            Boolean this$shouldIntercept = this.getShouldIntercept();
            Boolean other$shouldIntercept = other.getShouldIntercept();
            if (this$shouldIntercept == null ? other$shouldIntercept != null : !((Object)this$shouldIntercept).equals(other$shouldIntercept)) {
                return false;
            }
            Boolean this$enableSmartHosting = this.getEnableSmartHosting();
            Boolean other$enableSmartHosting = other.getEnableSmartHosting();
            if (this$enableSmartHosting == null ? other$enableSmartHosting != null : !((Object)this$enableSmartHosting).equals(other$enableSmartHosting)) {
                return false;
            }
            Boolean this$enableBreaker = this.getEnableBreaker();
            Boolean other$enableBreaker = other.getEnableBreaker();
            if (this$enableBreaker == null ? other$enableBreaker != null : !((Object)this$enableBreaker).equals(other$enableBreaker)) {
                return false;
            }
            Integer this$hourPlus = this.getHourPlus();
            Integer other$hourPlus = other.getHourPlus();
            if (this$hourPlus == null ? other$hourPlus != null : !((Object)this$hourPlus).equals(other$hourPlus)) {
                return false;
            }
            String this$adGroupId = this.getAdGroupId();
            String other$adGroupId = other.getAdGroupId();
            if (this$adGroupId == null ? other$adGroupId != null : !this$adGroupId.equals(other$adGroupId)) {
                return false;
            }
            BigDecimal this$charge = this.getCharge();
            BigDecimal other$charge = other.getCharge();
            if (this$charge == null ? other$charge != null : !((Object)this$charge).equals(other$charge)) {
                return false;
            }
            BigDecimal this$billCost = this.getBillCost();
            BigDecimal other$billCost = other.getBillCost();
            if (this$billCost == null ? other$billCost != null : !((Object)this$billCost).equals(other$billCost)) {
                return false;
            }
            BigDecimal this$roi = this.getRoi();
            BigDecimal other$roi = other.getRoi();
            if (this$roi == null ? other$roi != null : !((Object)this$roi).equals(other$roi)) {
                return false;
            }
            List<String> this$fetchKuaishouAdGroupIds = this.getFetchKuaishouAdGroupIds();
            List<String> other$fetchKuaishouAdGroupIds = other.getFetchKuaishouAdGroupIds();
            if (this$fetchKuaishouAdGroupIds == null ? other$fetchKuaishouAdGroupIds != null : !((Object)this$fetchKuaishouAdGroupIds).equals(other$fetchKuaishouAdGroupIds)) {
                return false;
            }
            String this$billCostCpaFormula = this.getBillCostCpaFormula();
            String other$billCostCpaFormula = other.getBillCostCpaFormula();
            return !(this$billCostCpaFormula == null ? other$billCostCpaFormula != null : !this$billCostCpaFormula.equals(other$billCostCpaFormula));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComputeParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNeedPlusCount();
            Long $conversionNum = this.getConversionNum();
            result = result * 59 + ($conversionNum == null ? 43 : ((Object)$conversionNum).hashCode());
            Boolean $shouldIntercept = this.getShouldIntercept();
            result = result * 59 + ($shouldIntercept == null ? 43 : ((Object)$shouldIntercept).hashCode());
            Boolean $enableSmartHosting = this.getEnableSmartHosting();
            result = result * 59 + ($enableSmartHosting == null ? 43 : ((Object)$enableSmartHosting).hashCode());
            Boolean $enableBreaker = this.getEnableBreaker();
            result = result * 59 + ($enableBreaker == null ? 43 : ((Object)$enableBreaker).hashCode());
            Integer $hourPlus = this.getHourPlus();
            result = result * 59 + ($hourPlus == null ? 43 : ((Object)$hourPlus).hashCode());
            String $adGroupId = this.getAdGroupId();
            result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
            BigDecimal $charge = this.getCharge();
            result = result * 59 + ($charge == null ? 43 : ((Object)$charge).hashCode());
            BigDecimal $billCost = this.getBillCost();
            result = result * 59 + ($billCost == null ? 43 : ((Object)$billCost).hashCode());
            BigDecimal $roi = this.getRoi();
            result = result * 59 + ($roi == null ? 43 : ((Object)$roi).hashCode());
            List<String> $fetchKuaishouAdGroupIds = this.getFetchKuaishouAdGroupIds();
            result = result * 59 + ($fetchKuaishouAdGroupIds == null ? 43 : ((Object)$fetchKuaishouAdGroupIds).hashCode());
            String $billCostCpaFormula = this.getBillCostCpaFormula();
            result = result * 59 + ($billCostCpaFormula == null ? 43 : $billCostCpaFormula.hashCode());
            return result;
        }

        public String toString() {
            return "SummarySmartHostingScheduler.ComputeParameter(adGroupId=" + this.getAdGroupId() + ", charge=" + this.getCharge() + ", conversionNum=" + this.getConversionNum() + ", billCost=" + this.getBillCost() + ", roi=" + this.getRoi() + ", shouldIntercept=" + this.getShouldIntercept() + ", needPlusCount=" + this.getNeedPlusCount() + ", enableSmartHosting=" + this.getEnableSmartHosting() + ", fetchKuaishouAdGroupIds=" + this.getFetchKuaishouAdGroupIds() + ", enableBreaker=" + this.getEnableBreaker() + ", hourPlus=" + this.getHourPlus() + ", billCostCpaFormula=" + this.getBillCostCpaFormula() + ")";
        }
    }

    static enum SmartHostingInfoFieldEnum {
        charge("charge", ComputeParameter::getCharge, ""),
        conversionNum("conversionNum", ComputeParameter::getConversionNum, BigDecimal.ZERO.toString()),
        billCost("billCost", ComputeParameter::getBillCost, "--"),
        roi("roi", ComputeParameter::getRoi, "--"),
        enableSmartHosting("enableSmartHosting", ComputeParameter::getEnableSmartHosting, Boolean.FALSE.toString()),
        enableBreaker("enableBreaker", ComputeParameter::getEnableBreaker, ""),
        billCostCpaFormula("billCostCpaFormula", ComputeParameter::getBillCostCpaFormula, "");

        public final String fieldName;
        public final Function<ComputeParameter, Object> fetchFunction;
        public final String defaultValue;

        private SmartHostingInfoFieldEnum(String fieldName, Function<ComputeParameter, Object> fetchFunction, String defaultValue) {
            this.fieldName = fieldName;
            this.fetchFunction = fetchFunction;
            this.defaultValue = defaultValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Function<ComputeParameter, Object> getFetchFunction() {
            return this.fetchFunction;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

