/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.deduction;

import com.bxm.adscounter.rtb.common.control.deduction.DeductionControl;
import com.bxm.adscounter.rtb.common.control.deduction.DeductionControlConfig;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Deprecated
public class RedisDeductionControlImpl
implements DeductionControl {
    private static final Logger log = LoggerFactory.getLogger(RedisDeductionControlImpl.class);
    private static final int ONE_DAY_SEC = TypeHelper.castToInt((Object)Duration.ofDays(1L).getSeconds());
    private final DeductionControlConfig config;
    private final JedisPool jedisPool;
    private final MeterRegistry registry;

    public RedisDeductionControlImpl(JedisPool jedisPool, DeductionControlConfig config, MeterRegistry registry) {
        this.registry = registry;
        this.jedisPool = jedisPool;
        this.config = config;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)config.getDimension()), (Object)"dimension cannot be null");
        Preconditions.checkNotNull(config.getConsumer(), (Object)"consumer cannot be null");
        double ratio = config.getRatio();
        Preconditions.checkArgument((ratio >= 0.0 && ratio <= 1.0 ? 1 : 0) != 0, (Object)"ratio must >= 0 and <= 1");
    }

    @Override
    public void accept() {
        this.countAccept();
        this.countAcceptForGlobal();
        this.registry.counter("deduction.control.accept", this.tags()).increment();
    }

    @Override
    public void reject(String data) {
        this.countReject();
        this.countRejectForGlobal();
        Consumer<String> deductionConsumer = this.config.getDeductionConsumer();
        if (Objects.nonNull(deductionConsumer)) {
            deductionConsumer.accept(data);
        }
        this.registry.counter("deduction.control.reject", this.tags()).increment();
    }

    @Override
    public void push(String data) {
        double after;
        boolean feedbackIfNecessary;
        double stepValue = 1.0;
        double zeroRatio = 0.0;
        if (!this.isInitializedCountRate() && this.config.getRatio() > zeroRatio) {
            this.incrCountRateBy(stepValue);
        }
        boolean bl = feedbackIfNecessary = (after = this.incrCountRateBy(this.config.getRatio())) >= stepValue;
        if (feedbackIfNecessary) {
            this.incrCountRateBy(-stepValue);
            this.accept();
            Consumer<String> consumer = this.config.getConsumer();
            try {
                if (Objects.nonNull(consumer)) {
                    consumer.accept(data);
                }
            }
            catch (Exception e) {
                log.error("occur exception | accept: ", (Throwable)e);
            }
        } else {
            this.reject(data);
        }
        this.registry.counter("deduction.control", this.tags()).increment();
    }

    @Override
    public void delete() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String dimension = this.config.getDimension();
            String stringRateCountInitialized = RedisDeductionControlImpl.stringRateCountInitialized(dimension).generateKey();
            String stringCountRate = RedisDeductionControlImpl.stringCountRate(dimension).generateKey();
            String stringAccept = RedisDeductionControlImpl.stringAccept(dimension).generateKey();
            String stringAcceptForGlobal = RedisDeductionControlImpl.stringAcceptForGlobal(Objects.toString(this.config.getHitConfigId())).generateKey();
            String stringReject = RedisDeductionControlImpl.stringReject(dimension).generateKey();
            String stringRejectForGlobal = RedisDeductionControlImpl.stringRejectForGlobal(Objects.toString(this.config.getHitConfigId())).generateKey();
            jedis.del(new String[]{stringRateCountInitialized, stringCountRate, stringAccept, stringAcceptForGlobal, stringReject, stringRejectForGlobal});
        }
    }

    @Override
    public DeductionControlConfig getConfig() {
        return this.config;
    }

    private List<Tag> tags() {
        return Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"dim", (String)this.config.getDimension())});
    }

    private JedisPool getJedisPool() {
        return this.jedisPool;
    }

    private boolean isInitializedCountRate() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringRateCountInitialized(this.config.getDimension()).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incr {}", (Object)key, (Object)rs);
            }
            boolean bl = Optional.ofNullable(rs).orElse(1L) > 1L;
            return bl;
        }
    }

    private double incrCountRateBy(double incrementValue) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringCountRate(this.config.getDimension()).generateKey();
            double rs = jedis.incrByFloat(key, incrementValue);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incrBy {}", (Object)key, (Object)rs);
            }
            double d = rs;
            return d;
        }
    }

    private void countAccept() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringAccept(this.config.getDimension()).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void countReject() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringReject(this.config.getDimension()).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void countAcceptForGlobal() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringAcceptForGlobal(Objects.toString(this.config.getHitConfigId())).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private void countRejectForGlobal() {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisDeductionControlImpl.stringRejectForGlobal(Objects.toString(this.config.getHitConfigId())).generateKey();
            Long rs = jedis.incr(key);
            jedis.expire(key, ONE_DAY_SEC);
            if (log.isDebugEnabled()) {
                log.debug("{} after incrBy {}", (Object)key, (Object)rs);
            }
        }
    }

    private static KeyGenerator stringRateCountInitialized(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "init", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringCountRate(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "rate", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringAccept(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "accept", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringAcceptForGlobal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "accept_global", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringReject(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "reject", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static KeyGenerator stringRejectForGlobal(String dimension) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "deduction", "reject_global", RedisDeductionControlImpl.getDate(), dimension});
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }
}

