/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSmartConversionIntegration {
    private final PositionRtbService positionRtbService;
    private final RtbIntegrationFactory rtbIntegrationFactory;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    protected AbstractSmartConversionIntegration(PositionRtbService positionRtbService, RtbIntegrationFactory rtbIntegrationFactory, RatioControlRtbIntegration ratioControlRtbIntegration) {
        this.positionRtbService = positionRtbService;
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    protected abstract Set<Rtb> includes();

    protected abstract Set<Rtb> excludes();

    protected void doTicketClick(KeyValueMap clickLog) {
        Optional<Rtb> first;
        Optional<Rtb> first2;
        String tagid = (String)clickLog.getFirst((Object)"tagid");
        PositionRtb config = this.positionRtbService.get(tagid);
        if (Objects.isNull(config)) {
            return;
        }
        Integer sourceType = config.getSourceType();
        Rtb rtb = Rtb.of(sourceType);
        if (Objects.isNull((Object)rtb)) {
            return;
        }
        Set<Rtb> includes = this.includes();
        if (CollectionUtils.isNotEmpty(includes) && !(first2 = includes.stream().filter(e -> e == rtb).findFirst()).isPresent()) {
            return;
        }
        Set<Rtb> excludes = this.excludes();
        if (CollectionUtils.isNotEmpty(excludes) && (first = excludes.stream().filter(e -> e == rtb).findFirst()).isPresent()) {
            return;
        }
        RtbIntegration rtbIntegration = this.rtbIntegrationFactory.get(rtb);
        if (!(rtbIntegration instanceof ClickTracker)) {
            return;
        }
        ClickTracker clickTracker = (ClickTracker)((Object)rtbIntegration);
        String clickId = clickTracker.getClickIdOnInadsAdClickLog(clickLog);
        if (StringUtils.isBlank((String)clickId)) {
            return;
        }
        KeyValueMap clickTrackerEventLog = clickTracker.getClickTracker(clickId);
        if (Objects.isNull(clickTrackerEventLog)) {
            return;
        }
        String adGroupId = (String)clickTrackerEventLog.getFirst((Object)"ad_group_id");
        String app = clickTracker.getApp(clickLog);
        this.ratioControlRtbIntegration.onTicketClick(rtbIntegration, clickTrackerEventLog, clickLog, adGroupId, app);
    }
}

