/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio;

import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlBus;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchExceptionEvent;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFetchingScheduler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DataFetchingScheduler.class);
    private final RatioControl control;
    private final RatioControlBus bus;

    public DataFetchingScheduler(RatioControl control) {
        this.control = control;
        this.bus = control.getBus();
    }

    @Override
    public void run() {
        RatioControlConfig config = this.getConfig();
        EventPark eventPark = this.bus.getEventPark();
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Starting execute", (Object)config.getDimension());
            }
            Rtb rtb = this.bus.getInstance().rtb();
            DataFetcher fetcher = this.bus.getFactory().getDataFetcher(rtb);
            if (Objects.isNull(fetcher)) {
                return;
            }
            if (!config.isEnableCostControl()) {
                return;
            }
            Parameter parameter = Parameter.builder().advertiserId(config.getAdvertiserId()).tagId(config.getTagId()).adGroupId(config.getAdGroupId()).shallowEventType(config.getShallowEventType()).deepEventType(config.getDeepEventType()).advertiserName(config.getAdvertiserName()).build();
            List<AdGroupData> adGroupData = fetcher.fetchCurrentHourData(parameter);
            if (CollectionUtils.isEmpty(adGroupData)) {
                log.info("[{}] Not fetch data for ad_group_id={}", (Object)config.getDimension(), (Object)parameter.getAdGroupId());
                return;
            }
            eventPark.post((EventObject)new AdGroupFetchEvent(this, this.control, adGroupData, true));
            if (log.isInfoEnabled()) {
                log.info("[{}] Finish fetch task, size: {}, result: {}", new Object[]{config.getDimension(), adGroupData.size(), adGroupData});
            }
            this.processPreviousHourData(fetcher, parameter);
        }
        catch (DataFetchFailException e) {
            eventPark.post((EventObject)new AdGroupFetchExceptionEvent(this, e));
        }
        catch (Exception e) {
            log.error("run: ", (Throwable)e);
        }
    }

    private void processPreviousHourData(DataFetcher fetcher, Parameter parameter) {
        try {
            List<AdGroupData> previousHour = fetcher.fetchPreviousHourData(parameter);
            if (CollectionUtils.isNotEmpty(previousHour)) {
                this.bus.getEventPark().post((EventObject)new AdGroupFetchEvent(this, this.control, previousHour, false));
            }
        }
        catch (DataFetchFailException e) {
            log.warn("fetchPreviousHourData: {}", (Object)e.getMessage());
        }
    }

    private RatioControlConfig getConfig() {
        return this.control.getConfig();
    }
}

