/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.ratio.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.event.AdGroupFetchEvent;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class AdGroupFetchOpenLogEventListener
implements EventListener<AdGroupFetchEvent> {
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public AdGroupFetchOpenLogEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdGroupFetchEvent event) {
        RatioControl control = event.getControl();
        RatioControlConfig config = control.getConfig();
        String tagId = config.getTagId();
        Rtb rtb = control.getBus().getInstance().rtb();
        String adGroupId = config.getAdGroupId();
        List<AdGroupData> dataList = event.getAdGroupData();
        if (CollectionUtils.isNotEmpty(dataList)) {
            dataList.forEach(e -> {
                KeyValueMap map = new KeyValueMap();
                map.put("p", Production.COMMON.getName());
                map.put("mt", Common.Mt.RtbAdGroupDataFetch.original());
                map.put("tagid", tagId);
                map.put("rtb_id", (Object)rtb.getType());
                map.put("ad_group_id", adGroupId);
                map.put("time", (Object)System.currentTimeMillis());
                map.put("date", e.getDate());
                map.put("hour", (Object)e.getHour());
                map.put("charge", (Object)e.getCharge());
                map.put("shallow_conv_count", (Object)e.getShallowConvCount());
                map.put("shallow_conv_cost", (Object)e.getShallowConvCost());
                map.put("deep_conv_count", (Object)e.getDeepConvCount());
                map.put("deep_conv_cost", (Object)e.getDeepConvCost());
                map.put("conv_num_by_impression", (Object)e.getConvNumByImpression());
                String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
                this.openLogClient.asyncRequest(openLogRequestUri);
            });
        }
    }
}

