/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.feedback;

import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum ActionType {
    ACTIVITY_ATTEND("1"),
    ACTIVITY_REATTEND("2"),
    TICKET_CLICK("3"),
    TICKET_CONVERSION("4");

    private final String value;

    private ActionType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static ActionType of(KeyValueMap keyValueMap, PositionRtb config) {
        String mt = (String)keyValueMap.getFirst((Object)"mt");
        boolean isAdClick = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.AdClick.original());
        boolean isAdConversion = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.AdConversion.original());
        if (isAdClick) {
            return TICKET_CLICK;
        }
        if (isAdConversion) {
            return TICKET_CONVERSION;
        }
        if (Objects.isNull(config)) {
            return null;
        }
        boolean isActivityAttend = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.ActivityAttend.original());
        if (!isActivityAttend) {
            return null;
        }
        String activityOne = config.getActivityOne();
        String activityTwo = config.getActivityTwo();
        if (StringUtils.equals((CharSequence)activityOne, (CharSequence)"1") || StringUtils.equals((CharSequence)activityTwo, (CharSequence)"1")) {
            return ACTIVITY_ATTEND;
        }
        if (StringUtils.equals((CharSequence)activityOne, (CharSequence)"2") || StringUtils.equals((CharSequence)activityTwo, (CharSequence)"2")) {
            return ACTIVITY_REATTEND;
        }
        return null;
    }
}

