/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl;

import com.alibaba.fastjson.JSONException;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public abstract class AbstractHttpRtbIntegration
implements RtbIntegration {
    private final HttpClient httpClient;
    protected final RtbConfig config;
    private static final List<Integer> SUCCESS_HTTP_CODE = Lists.newArrayList((Object[])new Integer[]{200});

    protected AbstractHttpRtbIntegration(RtbConfig config) {
        this(config, AbstractHttpRtbIntegration.createHttpClient(config));
    }

    protected AbstractHttpRtbIntegration(RtbConfig config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public static HttpClient createHttpClient(RtbConfig config) {
        int maxTotal = config.getMaxTotal();
        int defaultMaxPerRoute = config.getDefaultMaxPerRoute();
        int connectionRequestTimeout = config.getConnectionRequestTimeout();
        int connectTimeout = config.getConnectTimeout();
        int socketTimeout = config.getSocketTimeout();
        return HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout);
    }

    protected abstract HttpRequestBase create(FeedbackRequest var1) throws RtbIntegrationException;

    protected abstract FeedbackResponse convert(FeedbackRequest var1, String var2) throws RtbIntegrationException;

    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    protected List<Integer> successHttpCode() {
        return SUCCESS_HTTP_CODE;
    }

    @Override
    public String getFeedbackUrl() {
        return this.config.getUrl();
    }

    @Override
    public FeedbackResponse doFeedback(FeedbackRequest request) throws RtbIntegrationException {
        return this.doFeedback(request, 0);
    }

    @Override
    public FeedbackResponse doFeedback(FeedbackRequest request, int status) throws RtbIntegrationException {
        HttpRequestBase requestBase = null;
        try {
            if (Objects.isNull(request)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, String.format("[%s] request object is null", new Object[]{this.rtb()}));
            }
            requestBase = this.create(request);
            request.setRequestUrl(requestBase.getURI().toString());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)requestBase);
            int statusCode = response.getStatusLine().getStatusCode();
            if (!this.successHttpCode().contains(statusCode)) {
                throw new RtbIntegrationException(FailType.ScNotOk, String.format("[%s] response statusCode is %d", new Object[]{this.rtb(), statusCode}));
            }
            boolean readBodyForHttpResponse = this.isReadBodyForHttpResponse();
            String body = readBodyForHttpResponse ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : null;
            FeedbackResponse feedbackResponse = this.convert(request, body);
            if (Objects.isNull(feedbackResponse)) {
                throw new RtbIntegrationException(FailType.ResponseIsNull, "convert feedback response is null");
            }
            feedbackResponse.setBody(body);
            FeedbackResponse feedbackResponse2 = feedbackResponse;
            return feedbackResponse2;
        }
        catch (IOException e) {
            throw new RtbIntegrationException(FailType.IoException, (Throwable)e);
        }
        catch (JSONException e) {
            throw new RtbIntegrationException(FailType.ResolveProtocolException, (Throwable)e);
        }
        catch (RtbIntegrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RtbIntegrationException(FailType.OtherException, (Throwable)e);
        }
        finally {
            if (Objects.nonNull(requestBase)) {
                requestBase.releaseConnection();
            }
        }
    }
}

