/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.cloudmusic;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.impl.cloudmusic.CloudMusicConfig;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.http.OkHttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudMusicRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(CloudMusicRtbIntegration.class);
    private final CloudMusicConfig config;

    public CloudMusicRtbIntegration(CloudMusicConfig config) {
        super(config, CloudMusicRtbIntegration.createHttpClient(config));
        this.config = config;
    }

    public static HttpClient createHttpClient(RtbConfig config) {
        int maxTotal = config.getMaxTotal();
        int defaultMaxPerRoute = config.getDefaultMaxPerRoute();
        int connectionRequestTimeout = config.getConnectionRequestTimeout();
        int connectTimeout = config.getConnectTimeout();
        int socketTimeout = config.getSocketTimeout();
        return HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout, "TLSv1.2");
    }

    @Override
    public Rtb rtb() {
        return Rtb.CloudMusic;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String clickId = (String)keyValueMap.getFirst((Object)"click_id");
        if (StringUtils.isBlank((String)clickId) && StringUtils.isBlank((String)(clickId = (String)keyValueMap.getFirst((Object)"refer")))) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found callback from keyValueMap. keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(15);
        params.put("platType", this.config.getPlatType());
        params.put("source", keyValueMap.getFirst((Object)"source_music"));
        params.put("event", request.getEventType());
        params.put("clickid", clickId);
        params.put("appkey", keyValueMap.getFirst((Object)"appkey"));
        params.put("timestamp", System.currentTimeMillis() / 1000L);
        params.put("sign", this.getSign(params, (String)keyValueMap.getFirst((Object)"appsecret")));
        String url = OkHttpUtils.appendParams((String)this.config.getUrl(), params);
        return new HttpGet(url);
    }

    private String getSign(Map<String, Object> params, String token) {
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(params);
        Set set = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry entry : set) {
            valueSb.append(token).append((String)entry.getKey()).append((Object)(Objects.isNull(entry.getValue()) ? "" : entry.getValue()));
        }
        valueSb.append(token);
        return DigestUtils.md5Hex((String)valueSb.toString()).toUpperCase();
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        if (StringUtils.isBlank((String)body)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (jsonObject.getInteger("code") == 200) {
            feedbackResponse.setSuccess(true);
        } else {
            feedbackResponse.setSuccess(false);
        }
        return feedbackResponse;
    }
}

